/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.filechooserfield;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.IDropDownButtonListener;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldWithDropDownButton;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.filechooserfield.ISwingScoutFileChooserField;

public class SwingScoutFileChooserField
extends SwingScoutValueFieldComposite<IFileChooserField>
implements ISwingScoutFileChooserField {
    private static final long serialVersionUID = 1L;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JTextComponent textField = this.createTextField(container);
        Document doc = textField.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingScoutFileChooserField.this.setInputDirty(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingScoutFileChooserField.this.setInputDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingScoutFileChooserField.this.setInputDirty(true);
            }
        });
        InputMap inputMap = textField.getInputMap(0);
        inputMap.put(SwingUtility.createKeystroke("F2"), "fileChooser");
        ActionMap actionMap = textField.getActionMap();
        actionMap.put("fileChooser", new P_SwingFileChooserAction());
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected JTextComponent createTextField(JComponent container) {
        JTextFieldWithDropDownButton textField = new JTextFieldWithDropDownButton(this.getSwingEnvironment());
        container.add(textField);
        textField.addDropDownButtonListener(new IDropDownButtonListener(){

            @Override
            public void iconClicked(Object source) {
                SwingScoutFileChooserField.this.getSwingTextField().requestFocus();
                SwingScoutFileChooserField.this.handleSwingFileChooserAction();
            }

            @Override
            public void menuClicked(Object source) {
                SwingScoutFileChooserField.this.handleSwingPopup((JComponent)source);
            }
        });
        return textField;
    }

    @Override
    public JTextComponent getSwingTextField() {
        return (JTextComponent)this.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IFileChooserField f = (IFileChooserField)this.getScoutObject();
        this.setFileIconIdFromScout(f.getFileIconId());
        if (this.getSwingField() instanceof JTextFieldWithDropDownButton) {
            ((JTextFieldWithDropDownButton)this.getSwingTextField()).setMenuEnabled(((IFileChooserField)this.getScoutObject()).hasMenus());
        }
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        JTextComponent swingField = this.getSwingTextField();
        swingField.setText(s);
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        if (this.getSwingTextField() instanceof JTextField) {
            int swingAlign = SwingUtility.createHorizontalAlignment(scoutAlign);
            ((JTextField)this.getSwingTextField()).setHorizontalAlignment(swingAlign);
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        if (this.getSwingField() instanceof JTextFieldWithDropDownButton) {
            ((JTextFieldWithDropDownButton)this.getSwingTextField()).setDropDownButtonEnabled(b);
        }
    }

    protected void setFileIconIdFromScout(String s) {
        if (this.getSwingField() instanceof JTextFieldWithDropDownButton) {
            ((JTextFieldWithDropDownButton)this.getSwingField()).setIconGroup(new IconGroup(this.getSwingEnvironment(), s));
        }
    }

    @Override
    protected boolean handleSwingInputVerifier() {
        final String text = this.getSwingTextField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IFileChooserField)this.getScoutObject()).getDisplayText()) && ((IFileChooserField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IFileChooserField)SwingScoutFileChooserField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getSwingEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        this.getSwingEnvironment().dispatchImmediateSwingJobs();
        return true;
    }

    @Override
    protected void handleSwingFocusGained() {
        super.handleSwingFocusGained();
        JTextComponent swingField = this.getSwingTextField();
        if (swingField.getDocument().getLength() > 0) {
            swingField.setCaretPosition(swingField.getDocument().getLength());
            swingField.moveCaretPosition(0);
        }
    }

    protected boolean isFileChooserEnabled() {
        if (this.getSwingField() instanceof JTextFieldWithDropDownButton) {
            return ((JTextFieldWithDropDownButton)this.getSwingTextField()).isDropDownButtonEnabled();
        }
        return false;
    }

    protected void handleSwingFileChooserAction() {
        if (this.isFileChooserEnabled()) {
            Runnable scoutJob = new Runnable(){

                @Override
                public void run() {
                    IFileChooser fc = ((IFileChooserField)SwingScoutFileChooserField.this.getScoutObject()).getFileChooser();
                    final File[] files = fc.startChooser();
                    Runnable swingJob = new Runnable(){

                        @Override
                        public void run() {
                            if (files != null && files.length > 0) {
                                SwingScoutFileChooserField.this.getSwingTextField().setText(files[0].getAbsolutePath());
                                SwingScoutFileChooserField.this.handleSwingInputVerifier();
                            }
                        }
                    };
                    if (SwingScoutFileChooserField.this.getSwingEnvironment() != null) {
                        SwingScoutFileChooserField.this.getSwingEnvironment().invokeSwingLater(swingJob);
                    }
                }
            };
            this.getSwingEnvironment().invokeScoutLater(scoutJob, 0L);
        }
    }

    protected void handleSwingPopup(final JComponent target) {
        if (((IFileChooserField)this.getScoutObject()).hasMenus()) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((IFileChooserField)SwingScoutFileChooserField.this.getScoutObject()).getUIFacade().firePopupFromUI();
                    int x = 0;
                    if (target instanceof JTextFieldWithDropDownButton) {
                        JTextFieldWithDropDownButton tf = (JTextFieldWithDropDownButton)target;
                        x = tf.getWidth() - tf.getMargin().right;
                    }
                    Point point = new Point(x, target.getHeight());
                    new SwingPopupWorker(SwingScoutFileChooserField.this.getSwingEnvironment(), target, point, scoutMenus).enqueue();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("fileIconId")) {
            this.setFileIconIdFromScout((String)newValue);
        }
    }

    private class P_SwingFileChooserAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_SwingFileChooserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutFileChooserField.this.handleSwingFileChooserAction();
        }
    }
}

