/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.groupbox;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.ISwingScoutGroupBoxButtonbar;

public class SwingScoutGroupBoxButtonbar
implements ISwingScoutGroupBoxButtonbar {
    private IGroupBox m_scoutGroupBox;
    private ISwingEnvironment m_environment;
    private JPanel m_swingContainer;
    private JPanel m_leftButtonPart;
    private JComponent m_rightButtonPart;

    public void createField(IGroupBox scoutGroupBox, ISwingEnvironment environment) {
        this.m_scoutGroupBox = scoutGroupBox;
        this.m_environment = environment;
        this.m_swingContainer = new JPanelEx(new BorderLayoutEx(4, 0));
        this.m_swingContainer.setOpaque(false);
        if (!SwingUtility.isSynth()) {
            this.m_swingContainer.setBorder(UIManager.getBorder("GroupBoxButtonBar.border"));
        }
        this.m_swingContainer.setName("Synth.GroupBoxButtonBar");
        int hgap = UIManager.getInt("GroupBoxButtonBar.horizontalGap");
        if (hgap <= 0) {
            hgap = 12;
        }
        this.m_leftButtonPart = new JPanelEx();
        this.m_leftButtonPart.setOpaque(false);
        this.m_leftButtonPart.setName("customProcessButtons");
        this.m_leftButtonPart.setLayout(new FlowLayoutEx(2, hgap, 6));
        this.m_rightButtonPart = new JPanelEx();
        this.m_rightButtonPart.setOpaque(false);
        this.m_rightButtonPart.setName("systemProcessButtons");
        this.m_rightButtonPart.setLayout(new FlowLayoutEx(4, hgap, 6));
        this.m_swingContainer.add((Component)this.m_leftButtonPart, "West");
        this.m_swingContainer.add((Component)this.m_rightButtonPart, "East");
        IFormField[] iFormFieldArray = this.getScoutGroupBox().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IButton b;
            IFormField f = iFormFieldArray[n2];
            if (f instanceof IButton && (b = (IButton)f).isProcessButton()) {
                ISwingScoutFormField swingScoutComposite;
                if (b.getGridData().horizontalAlignment <= 0) {
                    swingScoutComposite = this.getEnvironment().createFormField(this.m_leftButtonPart, (IFormField)b);
                    this.m_leftButtonPart.add(swingScoutComposite.getSwingContainer());
                } else {
                    swingScoutComposite = this.getEnvironment().createFormField(this.m_rightButtonPart, (IFormField)b);
                    this.m_rightButtonPart.add(swingScoutComposite.getSwingContainer());
                }
            }
            ++n2;
        }
    }

    private void updateButtonbarVisibility() {
        this.m_swingContainer.doLayout();
    }

    public IGroupBox getScoutGroupBox() {
        return this.m_scoutGroupBox;
    }

    public ISwingEnvironment getEnvironment() {
        return this.m_environment;
    }

    @Override
    public JPanel getSwingContainer() {
        return this.m_swingContainer;
    }

    public JPanel getLeftButtonPart() {
        return this.m_leftButtonPart;
    }

    public JComponent getRightButtonPart() {
        return this.m_rightButtonPart;
    }
}

