/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.IMultiSplitStrategy;

public class ColumnSplitStrategy
implements IMultiSplitStrategy {
    protected int m_span;
    protected int[][] m_location;
    protected int[][] m_definedLocation;
    private Job m_storageJob;
    private final ClientUIPreferences m_prefs;

    public ColumnSplitStrategy(ClientUIPreferences prefs) {
        int c;
        int r;
        this.m_prefs = prefs;
        this.m_span = 1000;
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[4];
        nArray[1] = 250;
        nArray[2] = 750;
        nArray[3] = 1000;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 250;
        nArray2[2] = 750;
        nArray2[3] = 1000;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 250;
        nArray3[2] = 750;
        nArray3[3] = 1000;
        nArrayArray[2] = nArray3;
        this.m_definedLocation = nArrayArray;
        int[][] saved = null;
        try {
            saved = this.validateImportedLocations(this.m_prefs.getDesktopColumnSplits(3, 4));
        }
        catch (Throwable throwable) {}
        if (saved != null) {
            r = 0;
            while (r < this.m_definedLocation.length) {
                c = 0;
                while (c < this.m_definedLocation[r].length) {
                    this.m_definedLocation[r][c] = saved[r][c];
                    ++c;
                }
                ++r;
            }
        }
        this.m_location = new int[this.m_definedLocation.length][this.m_definedLocation[0].length];
        r = 0;
        while (r < this.m_definedLocation.length) {
            c = 0;
            while (c < this.m_definedLocation[r].length) {
                this.m_location[r][c] = this.m_definedLocation[r][c];
                ++c;
            }
            ++r;
        }
    }

    protected int[][] validateImportedLocations(int[][] in) {
        if (in != null && in.length == 3 && in[0].length == 4) {
            int r = 0;
            while (r < in.length) {
                in[r][0] = 0;
                if (r == 0) {
                    if (in[r][3] < 60) {
                        in[r][3] = 60;
                    }
                } else {
                    in[r][3] = in[0][3];
                }
                if (in[r][1] - 20 < in[r][0]) {
                    in[r][1] = in[r][0] + 20;
                }
                if (in[r][2] - 20 < in[r][1]) {
                    in[r][2] = in[r][1] + 20;
                }
                if (in[r][1] + 20 > in[r][2]) {
                    in[r][1] = in[r][2] - 20;
                }
                if (in[r][2] + 20 > in[r][3]) {
                    in[r][2] = in[r][3] - 20;
                }
                if (in[r][1] + 20 > in[r][2]) {
                    int mid = (in[r][1] + in[r][2]) / 2;
                    in[r][1] = mid - 10;
                    in[r][2] = mid + 10;
                }
                ++r;
            }
            return in;
        }
        return null;
    }

    @Override
    public void updateSpan(int newSpan) {
        this.m_span = newSpan;
        int r = 0;
        while (r < 3) {
            int rightColumnWidth = this.m_definedLocation[r][3] - this.m_definedLocation[r][2];
            this.m_location[r][3] = this.m_span;
            this.m_location[r][2] = this.m_span - rightColumnWidth;
            this.m_location[r][1] = this.m_definedLocation[r][1];
            if (this.m_location[r][1] + 20 > this.m_location[r][2]) {
                int mid = (this.m_location[r][1] + this.m_location[r][2]) / 2;
                this.m_location[r][1] = mid - 10;
                this.m_location[r][2] = mid + 10;
            }
            ++r;
        }
    }

    @Override
    public int getSplitLocation(int row, int col) {
        return this.m_location[row][col];
    }

    @Override
    public void setSplitLocation(int row, int col, int newLocation) {
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                if (this.m_location[row][0] + 20 >= newLocation || newLocation + 20 >= this.m_location[row][2]) break;
                this.m_location[row][col] = newLocation;
                break;
            }
            case 2: {
                if (this.m_location[row][1] + 20 >= newLocation || newLocation + 20 >= this.m_location[row][3]) break;
                this.m_location[row][col] = newLocation;
                break;
            }
        }
        int r = 0;
        while (r < this.m_definedLocation.length) {
            int c = 0;
            while (c < this.m_definedLocation[r].length) {
                this.m_definedLocation[r][c] = this.m_location[r][c];
                ++c;
            }
            ++r;
        }
        this.enqueueStore();
    }

    protected void enqueueStore() {
        if (this.m_storageJob == null) {
            this.m_storageJob = new Job("Store column splits"){

                protected IStatus run(IProgressMonitor monitor) {
                    ColumnSplitStrategy.this.m_prefs.setDesktopColumnSplits(ColumnSplitStrategy.this.m_definedLocation);
                    return Status.OK_STATUS;
                }
            };
        }
        this.m_storageJob.cancel();
        this.m_storageJob.schedule(400L);
    }
}

