/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class TableHtmlLinkDetector {
    private int m_rowIndex;
    private int m_columnIndex;
    private URL m_hyperlink;

    public boolean detect(JTable table, Point p) {
        block6: {
            this.m_rowIndex = -1;
            this.m_columnIndex = -1;
            this.m_hyperlink = null;
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            if (row >= 0 && col >= 0) {
                String s;
                AttributeSet set;
                Element elem;
                View v;
                Component c = table.prepareRenderer(table.getCellRenderer(row, col), row, col);
                if (!(c instanceof JComponent) || (v = (View)((JComponent)c).getClientProperty("html")) == null) break block6;
                HTMLDocument doc = (HTMLDocument)v.getDocument();
                if ((v = v.getView(0)) == null || doc == null) break block6;
                Rectangle r = table.getCellRect(row, col, false);
                Rectangle allocation = new Rectangle(0, 0, r.width, r.height);
                v.setSize(r.width, r.height);
                int pos = v.viewToModel(p.x - r.x, p.y - r.y, allocation, new Position.Bias[1]);
                if (pos < 0 || (elem = doc.getCharacterElement(pos)) == null || (set = (AttributeSet)elem.getAttributes().getAttribute(HTML.Tag.A)) == null || (s = (String)set.getAttribute(HTML.Attribute.HREF)) == null) break block6;
                try {
                    this.m_hyperlink = new URL(s);
                    this.m_rowIndex = row;
                    this.m_columnIndex = col;
                    return true;
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        this.m_hyperlink = new URL(new URL("http://local"), s);
                        this.m_rowIndex = row;
                        this.m_columnIndex = col;
                        return true;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return false;
    }

    public URL getHyperlink() {
        return this.m_hyperlink;
    }

    public int getRowIndex() {
        return this.m_rowIndex;
    }

    public int getColumnIndex() {
        return this.m_columnIndex;
    }
}

