/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.table.AbstractKeyboardNavigationSupport;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableColumnModel;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableModel;
import org.eclipse.scout.rt.ui.swing.ext.JTableEx;

public abstract class TableKeyboardNavigationSupport
extends AbstractKeyboardNavigationSupport {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableKeyboardNavigationSupport.class);
    private final JTableEx m_table;
    private int m_contextColumnIndex = -1;
    private P_MouseListener m_mouseListener;
    private P_KeyListener m_keyListener;

    public TableKeyboardNavigationSupport(JTableEx table) {
        this(table, 500L);
    }

    public TableKeyboardNavigationSupport(JTableEx table, long delay) {
        super(delay);
        this.m_table = table;
        this.attachListeners();
    }

    public void dispose() {
        this.detachListeners();
    }

    public void resetContextColumnIndex() {
        this.m_contextColumnIndex = -1;
    }

    private void attachListeners() {
        if (this.m_mouseListener == null) {
            this.m_mouseListener = new P_MouseListener();
            this.m_table.addMouseListener(this.m_mouseListener);
        }
        if (this.m_keyListener == null) {
            this.m_keyListener = new P_KeyListener();
            this.m_table.addKeyListener(this.m_keyListener);
        }
    }

    private void detachListeners() {
        if (this.m_mouseListener != null) {
            this.m_table.removeMouseListener(this.m_mouseListener);
            this.m_mouseListener = null;
        }
        if (this.m_keyListener != null) {
            this.m_table.removeKeyListener(this.m_keyListener);
            this.m_keyListener = null;
        }
    }

    @Override
    void handleSearchPattern(final String regex) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int startIndex;
                SwingTableModel tableModel = (SwingTableModel)TableKeyboardNavigationSupport.this.m_table.getModel();
                int column = TableKeyboardNavigationSupport.this.m_contextColumnIndex;
                if (column < 0 && TableKeyboardNavigationSupport.this.m_table.getColumnCount() > 0) {
                    column = 0;
                }
                if (column < 0) {
                    return;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("finding regex:" + regex + " in column " + tableModel.getColumnName(column));
                }
                startIndex = (startIndex = TableKeyboardNavigationSupport.this.m_table.getSelectionModel().getAnchorSelectionIndex()) < 0 ? 0 : ++startIndex;
                int itemCount = TableKeyboardNavigationSupport.this.m_table.getRowCount();
                int i = 0;
                while (i < itemCount) {
                    int rowIndex = (startIndex + i) % itemCount;
                    String value = tableModel.getValueAt(rowIndex, column).toString();
                    if (value.toLowerCase().matches(regex)) {
                        TableKeyboardNavigationSupport.this.handleKeyboardNavigation(rowIndex);
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    abstract void handleKeyboardNavigation(int var1);

    private class P_KeyListener
    extends KeyAdapter {
        private P_KeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (SwingUtilities.isDescendingFrom(e.getComponent(), TableKeyboardNavigationSupport.this.m_table)) {
                char c;
                String keyStrokeText = SwingUtility.getKeyStrokeText(e);
                String keyText = SwingUtility.getKeyText(e);
                if (keyStrokeText != null && keyText.length() == 1 && ((c = keyText.charAt(0)) == ' ' || Character.isLetterOrDigit(c))) {
                    TableKeyboardNavigationSupport.this.addChar(c);
                }
            }
        }
    }

    private class P_MouseListener
    extends MouseAdapter {
        private P_MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SwingTableColumnModel columnModel = (SwingTableColumnModel)TableKeyboardNavigationSupport.this.m_table.getColumnModel();
            int uiIndex = TableKeyboardNavigationSupport.this.m_table.columnAtPoint(e.getPoint());
            TableKeyboardNavigationSupport.this.m_contextColumnIndex = columnModel.getColumn(uiIndex).getModelIndex();
        }
    }
}

