/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.concurrency;

import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.concurrency.LoopDetector;

public class SwingScoutSynchronizer {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutSynchronizer.class);
    private ISwingEnvironment m_env;
    private LoopDetector m_loopDetector;

    public SwingScoutSynchronizer(ISwingEnvironment env) {
        this.m_env = env;
        this.m_loopDetector = new LoopDetector(5000L, 2500, 10);
    }

    private boolean isModelThread() {
        return ClientSyncJob.getCurrentSession() == this.m_env.getScoutSession() && ClientSyncJob.isSyncClientJob();
    }

    public JobEx invokeScoutLater(final Runnable j, long cancelTimeout) {
        if (this.isModelThread()) {
            LOG.warn("trying to queue scout runnable but already in scout thread: " + j);
            j.run();
            return null;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("queueing scout runnable from outside swing thread: " + j);
        }
        this.m_loopDetector.addSample();
        if (this.m_loopDetector.isArmed()) {
            LOG.warn("loop detection: " + j, (Throwable)new Exception("Loop detected"));
            return null;
        }
        final long deadLine = cancelTimeout > 0L ? System.currentTimeMillis() + cancelTimeout : -1L;
        ClientSyncJob eclipseJob = new ClientSyncJob("Swing post::" + j, this.m_env.getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                if (deadLine < 0L || deadLine > System.currentTimeMillis()) {
                    j.run();
                }
            }
        };
        eclipseJob.schedule();
        return eclipseJob;
    }

    public void invokeSwingLater(Runnable j) {
        if (SwingUtilities.isEventDispatchThread()) {
            LOG.warn("trying to queue swing runnable but already in swing thread: " + j);
            j.run();
            return;
        }
        if (!this.isModelThread()) {
            throw new IllegalStateException("queueing swing runnable from outside scout thread: " + j);
        }
        SwingUtilities.invokeLater(j);
    }
}

