/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;

public class BorderLayoutEx
extends BorderLayout {
    private static final long serialVersionUID = 1L;

    public BorderLayoutEx() {
    }

    public BorderLayoutEx(int hgap, int vgap) {
        super(hgap, vgap);
    }

    protected Dimension getLayoutSize(Container parent, int sizeflag) {
        Dimension d;
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        Dimension dim = new Dimension(0, 0);
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        Component c = null;
        c = this.getChild("East", ltr);
        if (c != null) {
            d = SwingLayoutUtility.getSize(c, sizeflag);
            if (sizeflag == 2) {
                this.doMaxSizeRangeCheck(d);
            }
            dim.width += d.width + hgap;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild("West", ltr)) != null) {
            d = SwingLayoutUtility.getSize(c, sizeflag);
            if (sizeflag == 2) {
                this.doMaxSizeRangeCheck(d);
            }
            dim.width += d.width + hgap;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild("Center", ltr)) != null) {
            d = SwingLayoutUtility.getSize(c, sizeflag);
            if (sizeflag == 2) {
                this.doMaxSizeRangeCheck(d);
            }
            dim.width += d.width;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild("North", ltr)) != null) {
            d = SwingLayoutUtility.getSize(c, sizeflag);
            if (sizeflag == 2) {
                this.doMaxSizeRangeCheck(d);
            }
            dim.width = Math.max(d.width, dim.width);
            dim.height += d.height + vgap;
        }
        if ((c = this.getChild("South", ltr)) != null) {
            d = SwingLayoutUtility.getSize(c, sizeflag);
            if (sizeflag == 2) {
                this.doMaxSizeRangeCheck(d);
            }
            dim.width = Math.max(d.width, dim.width);
            dim.height += d.height + vgap;
        }
        if (dim.width > 0 && dim.height > 0) {
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
        }
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return new Dimension(this.getLayoutSize(parent, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return new Dimension(this.getLayoutSize(parent, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return new Dimension(this.getLayoutSize(parent, 2));
        }
    }

    protected void doMaxSizeRangeCheck(Dimension d) {
        if (d.width > 1000000) {
            d.width = 1000000;
        }
        if (d.height > 1000000) {
            d.height = 1000000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int cw;
            int ch;
            Dimension d;
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                c.setBounds(0, 0, 0, 0);
                ++n2;
            }
            Insets insets = parent.getInsets();
            int top = insets.top;
            int bottom = parent.getHeight() - insets.bottom;
            int left = insets.left;
            int right = parent.getWidth() - insets.right;
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            boolean ltr = parent.getComponentOrientation().isLeftToRight();
            Component c = null;
            c = this.getChild("North", ltr);
            if (c != null) {
                c.setSize(right - left, c.getHeight());
                d = c.getPreferredSize();
                ch = Math.max(0, Math.min(bottom - top, d.height));
                c.setBounds(left, top, right - left, ch);
                top += ch + vgap;
            }
            if ((c = this.getChild("South", ltr)) != null) {
                c.setSize(right - left, c.getHeight());
                d = c.getPreferredSize();
                ch = Math.max(0, Math.min(bottom - top, d.height));
                c.setBounds(left, bottom - ch, right - left, ch);
                bottom -= ch + vgap;
            }
            if ((c = this.getChild("West", ltr)) != null) {
                c.setSize(c.getWidth(), bottom - top);
                d = c.getPreferredSize();
                cw = Math.max(0, Math.min(right - left, d.width));
                c.setBounds(left, top, cw, bottom - top);
                left += cw + hgap;
            }
            if ((c = this.getChild("East", ltr)) != null) {
                c.setSize(c.getWidth(), bottom - top);
                d = c.getPreferredSize();
                cw = Math.max(0, Math.min(right - left, d.width));
                c.setBounds(right - cw, top, cw, bottom - top);
                right -= cw + hgap;
            }
            if ((c = this.getChild("Center", ltr)) != null) {
                int cw2 = Math.max(0, right - left);
                ch = Math.max(0, bottom - top);
                c.setBounds(left, top, cw2, ch);
            }
        }
    }

    private Component getChild(String key, boolean ltr) {
        Component result = null;
        if (key == "North") {
            Component firstLine = this.getLayoutComponent("First");
            Component north = this.getLayoutComponent("North");
            result = firstLine != null ? firstLine : north;
        } else if (key == "South") {
            Component lastLine = this.getLayoutComponent("Last");
            Component south = this.getLayoutComponent("South");
            result = lastLine != null ? lastLine : south;
        } else if (key == "West") {
            Component firstItem = this.getLayoutComponent("Before");
            Component lastItem = this.getLayoutComponent("After");
            Component west = this.getLayoutComponent("West");
            Component component = result = ltr ? firstItem : lastItem;
            if (result == null) {
                result = west;
            }
        } else if (key == "East") {
            Component firstItem = this.getLayoutComponent("Before");
            Component lastItem = this.getLayoutComponent("After");
            Component east = this.getLayoutComponent("East");
            Component component = result = ltr ? lastItem : firstItem;
            if (result == null) {
                result = east;
            }
        } else if (key == "Center") {
            Component center;
            result = center = this.getLayoutComponent("Center");
        }
        if (result != null && !result.isVisible()) {
            result = null;
        }
        return result;
    }
}

