/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;

public class JRootPaneEx
extends JRootPane {
    private static final long serialVersionUID = 1L;
    private Runnable m_reflowJob;

    @Override
    protected LayoutManager createRootLayout() {
        return new RootLayoutEx();
    }

    public void notifyVisibleChanged(Component c) {
        if (this.m_reflowJob == null) {
            this.m_reflowJob = new Runnable(){

                @Override
                public void run() {
                    try {
                        JRootPaneEx.this.evaluateReflow();
                    }
                    finally {
                        JRootPaneEx.this.m_reflowJob = null;
                    }
                }
            };
            SwingUtilities.invokeLater(this.m_reflowJob);
        }
    }

    protected void evaluateReflow() {
        if (this.getParent() == null || !this.isVisible() || !this.isShowing()) {
            return;
        }
        Dimension d = this.getSize();
        if (d.width > 0 && d.height > 0) {
            Dimension[] sizes = SwingLayoutUtility.getValidatedSizes(this);
            Dimension minMaxSize = new Dimension(Math.min(Math.max(d.width, sizes[0].width), sizes[2].width), Math.min(Math.max(d.height, sizes[0].height), sizes[2].height));
            int dw = minMaxSize.width - d.width;
            int dh = minMaxSize.height - d.height;
            int dwPref = sizes[1].width - d.width;
            int dhPref = sizes[1].height - d.height;
            if (dw != 0 || dh != 0 || dhPref > 0) {
                this.correctRootPaneSize(dw, dh, dwPref, dhPref);
            }
        }
    }

    @Override
    public void validate() {
        SwingLayoutUtility.invalidateSubtree(this);
        super.validate();
    }

    @Deprecated
    protected void correctRootPaneSize(int widthDelta, int heightDelta, int preferredWidthDelta, int preferredHeightDelta) {
        this.reflow();
    }

    protected void reflow() {
    }

    protected class RootLayoutEx
    extends JRootPane.RootLayout {
        private static final long serialVersionUID = 1L;

        protected RootLayoutEx() {
            super(JRootPaneEx.this);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            Insets i = JRootPaneEx.this.getInsets();
            Dimension mbd = JRootPaneEx.this.menuBar != null && JRootPaneEx.this.menuBar.isVisible() ? JRootPaneEx.this.menuBar.getMaximumSize() : new Dimension(0, 0);
            Dimension rd = JRootPaneEx.this.contentPane != null ? JRootPaneEx.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - i.top - i.bottom - mbd.height - 1);
            return new Dimension(Math.max(rd.width, mbd.width) + i.left + i.right, rd.height + mbd.height + i.top + i.bottom);
        }
    }
}

