/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class JTableHeaderEx
extends JTableHeader {
    private static final long serialVersionUID = 1L;
    private int m_preferredHeight;

    public void updatePreferredHeight() {
        int h = 0;
        Enumeration<TableColumn> en = this.getColumnModel().getColumns();
        while (en.hasMoreElements()) {
            Dimension d;
            Component comp;
            TableColumn col = en.nextElement();
            Object value = col.getHeaderValue();
            if (("" + value).indexOf("\n") < 0) continue;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getDefaultRenderer();
            }
            if ((comp = renderer.getTableCellRendererComponent(this.getTable(), value, false, false, 0, col.getModelIndex())) instanceof JLabel) {
                ((JLabel)comp).setVerticalAlignment(1);
                d = SwingLayoutUtility.getPreferredLabelSize((JLabel)comp, col.getWidth() - this.getColumnModel().getColumnMargin());
            } else {
                d = comp.getPreferredSize();
            }
            Insets insets = this.getInsets();
            d.height += insets.top + insets.bottom;
            h = Math.max(h, d.height);
        }
        if (this.m_preferredHeight != h) {
            this.m_preferredHeight = h;
            this.resizeAndRepaint();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.m_preferredHeight > 0) {
            d.height = this.m_preferredHeight;
        }
        return d;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.m_preferredHeight > 0) {
            d.height = this.m_preferredHeight;
        }
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (this.m_preferredHeight > 0) {
            d.height = this.m_preferredHeight;
        }
        return d;
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }
}

