/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.DropDownButtonIcon;
import org.eclipse.scout.rt.ui.swing.ext.IDropDownButtonListener;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldEx;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;

public class JTextFieldWithDropDownButton
extends JTextFieldEx {
    private static final long serialVersionUID = 1L;
    private DropDownButtonIcon m_dropDownButton;
    private Region m_cursorOverRegion = Region.TEXTAREA;
    private Cursor m_defaultCursor;
    private int m_insetsRight = 0;
    private Collection<IDropDownButtonListener> m_listeners = new ArrayList<IDropDownButtonListener>();

    public JTextFieldWithDropDownButton(ISwingEnvironment env) {
        this.registerMouseMotionListener();
        this.setTextFieldMargin();
        this.m_defaultCursor = this.getCursor();
        this.m_dropDownButton = new DropDownButtonIcon(env);
    }

    public void setIconGroup(IconGroup iconGroup) {
        this.m_dropDownButton.setIconGroup(iconGroup);
        this.setTextFieldMargin();
    }

    private void registerMouseMotionListener() {
        this.addMouseListener(new MouseAdapter(){
            MouseClickedBugFix fix;

            @Override
            public void mouseExited(MouseEvent e) {
                JTextFieldWithDropDownButton.this.showNormalIcon();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.fix = new MouseClickedBugFix(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.fix != null) {
                    this.fix.mouseReleased(this, e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.fix.mouseClicked()) {
                    return;
                }
                Region r = JTextFieldWithDropDownButton.this.getRegionTouchedByCursor(e.getPoint());
                if (r == Region.TEXTAREA) {
                    return;
                }
                boolean clickedMenu = false;
                if (e.getButton() == 3) {
                    clickedMenu = true;
                } else if (r == Region.MENU) {
                    clickedMenu = true;
                }
                if (clickedMenu) {
                    for (IDropDownButtonListener l : JTextFieldWithDropDownButton.this.m_listeners) {
                        l.menuClicked(e.getSource());
                    }
                } else {
                    for (IDropDownButtonListener l : JTextFieldWithDropDownButton.this.m_listeners) {
                        l.iconClicked(e.getSource());
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Region r = JTextFieldWithDropDownButton.this.getRegionTouchedByCursor(e.getPoint());
                switch (r) {
                    case TEXTAREA: {
                        JTextFieldWithDropDownButton.this.showNormalIcon();
                        break;
                    }
                    case ICON: 
                    case MENU: {
                        JTextFieldWithDropDownButton.this.highlightIconOrMenu(r);
                    }
                }
            }
        });
    }

    protected void setCursorOverRegion(Region cursorOverRegion) {
        Region oldRegion = this.m_cursorOverRegion;
        this.m_cursorOverRegion = cursorOverRegion;
        this.highlightIconPart();
        if (oldRegion != cursorOverRegion) {
            this.repaint();
        }
    }

    private void highlightIconPart() {
        switch (this.m_cursorOverRegion) {
            case TEXTAREA: {
                this.m_dropDownButton.setMouseOver(DropDownButtonIcon.MouseOver.NONE);
                break;
            }
            case MENU: {
                this.m_dropDownButton.setMouseOver(DropDownButtonIcon.MouseOver.ARROW);
                break;
            }
            case ICON: {
                this.m_dropDownButton.setMouseOver(DropDownButtonIcon.MouseOver.ICON);
            }
        }
    }

    protected void showNormalIcon() {
        this.setCursor(this.m_defaultCursor);
        this.setCursorOverRegion(Region.TEXTAREA);
    }

    private void highlightIconOrMenu(Region region) {
        Cursor cursor = Cursor.getPredefinedCursor(12);
        if (region == Region.ICON && !this.m_dropDownButton.isIconEnabled()) {
            cursor = Cursor.getPredefinedCursor(0);
        } else if (region == Region.MENU && !this.m_dropDownButton.isArrowEnabled()) {
            cursor = Cursor.getPredefinedCursor(0);
        }
        this.setCursor(cursor);
        this.setCursorOverRegion(region);
    }

    protected Region getRegionTouchedByCursor(Point cursorPosition) {
        int menuSize = 7;
        if (cursorPosition.x >= this.getWidth() - menuSize - this.m_insetsRight && cursorPosition.y <= this.getY() + menuSize) {
            return Region.MENU;
        }
        if (cursorPosition.x >= this.getWidth() - this.m_dropDownButton.getIconWidth() - this.m_insetsRight) {
            return Region.ICON;
        }
        return Region.TEXTAREA;
    }

    private void setTextFieldMargin() {
        Insets marginAndBorderInsets = this.getInsets();
        Insets marginInsets = this.getMargin();
        this.m_insetsRight = marginAndBorderInsets.right - marginInsets.right;
        int iconWidth = 0;
        if (this.m_dropDownButton != null) {
            iconWidth = this.m_dropDownButton.getIconWidth();
        }
        this.setMargin(new Insets(0, 0, 0, iconWidth + this.m_insetsRight));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintIcon(g);
    }

    private void paintIcon(Graphics g) {
        if (this.m_dropDownButton != null) {
            int x = this.getWidth() - this.m_dropDownButton.getIconWidth() - 6;
            int y = (this.getHeight() - this.m_dropDownButton.getIconHeight()) / 2;
            this.m_dropDownButton.paintIcon(this, g, x, y);
        }
    }

    public void addDropDownButtonListener(IDropDownButtonListener l) {
        this.m_listeners.add(l);
    }

    public void removeDropDownButtonListener(IDropDownButtonListener l) {
        this.m_listeners.remove(l);
    }

    public boolean isDropDownButtonEnabled() {
        return this.m_dropDownButton.isIconEnabled();
    }

    public void setDropDownButtonEnabled(boolean iconEnabled) {
        this.m_dropDownButton.setIconEnabled(iconEnabled);
    }

    public void setMenuEnabled(boolean menuEnabled) {
        this.m_dropDownButton.setArrowEnabled(menuEnabled);
    }

    static enum Region {
        TEXTAREA,
        ICON,
        MENU;

    }
}

