/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.AWTEvent;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class Windows7KeyHandler {
    private static final String CLIENT_PROPERTY_DEFAULT_BOUNDS = "Windows7DefaultBounds";
    private AWTEventListener m_listener;
    private boolean m_windowsKeyDown;

    public void install() {
        String osName = System.getProperty("os.name");
        if (osName == null || !osName.startsWith("Windows")) {
            return;
        }
        if (this.m_listener == null) {
            this.m_listener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent a) {
                    switch (a.getID()) {
                        case 401: {
                            switch (((KeyEvent)a).getKeyCode()) {
                                case 524: {
                                    Windows7KeyHandler.this.handleEnabled();
                                }
                            }
                            break;
                        }
                        case 402: {
                            switch (((KeyEvent)a).getKeyCode()) {
                                case 524: {
                                    Windows7KeyHandler.this.handleDisabled();
                                    break;
                                }
                                case 38: {
                                    Windows7KeyHandler.this.handleUp();
                                    break;
                                }
                                case 40: {
                                    Windows7KeyHandler.this.handleDown();
                                    break;
                                }
                                case 37: {
                                    Windows7KeyHandler.this.handleLeft();
                                    break;
                                }
                                case 39: {
                                    Windows7KeyHandler.this.handleRight();
                                }
                            }
                            break;
                        }
                        case 205: {
                            Windows7KeyHandler.this.handleDisabled();
                        }
                    }
                }
            };
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.m_listener, 72L);
    }

    public void uninstall() {
        if (this.m_listener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.m_listener);
            this.m_listener = null;
        }
    }

    private void handleEnabled() {
        this.m_windowsKeyDown = true;
    }

    private void handleDisabled() {
        this.m_windowsKeyDown = false;
    }

    private void handleUp() {
        Frame frame;
        if (this.m_windowsKeyDown && (frame = Windows7KeyHandler.getActiveFrame()) != null) {
            frame.setExtendedState(frame.getExtendedState() | 6);
        }
    }

    private void handleDown() {
        Frame frame;
        if (this.m_windowsKeyDown && (frame = Windows7KeyHandler.getActiveFrame()) != null) {
            frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFF9);
        }
    }

    private void handleLeft() {
        Frame frame;
        if (this.m_windowsKeyDown && (frame = Windows7KeyHandler.getActiveFrame()) != null) {
            boolean wasMaximized = (frame.getExtendedState() & 6) != 0;
            frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFF9);
            Rectangle curView = frame.getBounds();
            Rectangle defaultView = Windows7KeyHandler.getDefaultBounds(frame);
            Rectangle r = SwingUtility.getFullScreenBoundsFor(curView, false);
            Rectangle leftView = r.getBounds();
            Rectangle rightView = r.getBounds();
            int center = leftView.x + leftView.width / 2;
            leftView.width = center - leftView.x;
            rightView.width = rightView.x + rightView.width - center;
            rightView.x = center;
            if (!wasMaximized && leftView.equals(curView)) {
                r = SwingUtility.getOppositeFullScreenBoundsFor(frame.getBounds(), false);
                if (r != null) {
                    leftView = r.getBounds();
                    rightView = r.getBounds();
                    center = leftView.x + leftView.width / 2;
                    leftView.width = center - leftView.x;
                    rightView.width = rightView.x + rightView.width - center;
                    rightView.x = center;
                }
                frame.setBounds(rightView);
            } else if (!wasMaximized && rightView.equals(curView)) {
                if (defaultView != null) {
                    frame.setBounds(defaultView);
                } else {
                    frame.setBounds(leftView);
                }
            } else {
                if (!wasMaximized || defaultView == null) {
                    Windows7KeyHandler.setDefaultBounds(frame, curView);
                }
                frame.setBounds(leftView);
            }
        }
    }

    private void handleRight() {
        Frame frame;
        if (this.m_windowsKeyDown && (frame = Windows7KeyHandler.getActiveFrame()) != null) {
            boolean wasMaximized = (frame.getExtendedState() & 6) != 0;
            frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFF9);
            Rectangle curView = frame.getBounds();
            Rectangle defaultView = Windows7KeyHandler.getDefaultBounds(frame);
            Rectangle r = SwingUtility.getFullScreenBoundsFor(curView, false);
            Rectangle leftView = r.getBounds();
            Rectangle rightView = r.getBounds();
            int center = leftView.x + leftView.width / 2;
            leftView.width = center - leftView.x;
            rightView.width = rightView.x + rightView.width - center;
            rightView.x = center;
            if (!wasMaximized && rightView.equals(curView)) {
                r = SwingUtility.getOppositeFullScreenBoundsFor(frame.getBounds(), false);
                if (r != null) {
                    leftView = r.getBounds();
                    rightView = r.getBounds();
                    center = leftView.x + leftView.width / 2;
                    leftView.width = center - leftView.x;
                    rightView.width = rightView.x + rightView.width - center;
                    rightView.x = center;
                }
                frame.setBounds(leftView);
            } else if (!wasMaximized && leftView.equals(curView)) {
                if (defaultView != null) {
                    frame.setBounds(defaultView);
                } else {
                    frame.setBounds(rightView);
                }
            } else {
                if (!wasMaximized || defaultView == null) {
                    Windows7KeyHandler.setDefaultBounds(frame, curView);
                }
                frame.setBounds(rightView);
            }
        }
    }

    private static Frame getActiveFrame() {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (w instanceof Frame) {
            return (Frame)w;
        }
        return null;
    }

    private static Rectangle getDefaultBounds(Frame f) {
        JRootPane root;
        if (f instanceof RootPaneContainer && (root = ((RootPaneContainer)((Object)f)).getRootPane()) != null) {
            return (Rectangle)root.getClientProperty(CLIENT_PROPERTY_DEFAULT_BOUNDS);
        }
        return null;
    }

    private static void setDefaultBounds(Frame f, Rectangle r) {
        JRootPane root;
        if (f instanceof RootPaneContainer && (root = ((RootPaneContainer)((Object)f)).getRootPane()) != null) {
            root.putClientProperty(CLIENT_PROPERTY_DEFAULT_BOUNDS, r);
        }
    }
}

