/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.calendar;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarModel;
import org.eclipse.scout.rt.ui.swing.ext.calendar.DateChooser;
import org.eclipse.scout.rt.ui.swing.ext.calendar.SimpleCalendarItem;

public class DefaultCalendarModel
implements CalendarModel {
    private HashMap<Date, ArrayList<Object>> m_map = new HashMap();

    public void addItem(SimpleCalendarItem item) {
        Date a = this.getIndexDate(item.getFromDate(), null);
        Date b = this.getIndexDate(item.getToDate(), a);
        Calendar cal = Calendar.getInstance();
        cal.setTime(a);
        while (a.compareTo(b) <= 0) {
            ArrayList<Object> items = this.m_map.get(a);
            if (items == null) {
                items = new ArrayList();
                this.m_map.put(a, items);
            }
            items.add(item);
            cal.add(5, 1);
            a = cal.getTime();
        }
    }

    @Override
    public void moveItem(Object item, Date newDate) {
    }

    private Date getIndexDate(Date d, Date defaultDate) {
        if (d == null) {
            return defaultDate;
        }
        return DateChooser.truncDate(d);
    }

    @Override
    public Collection<Object> getItemsAt(Date dateTruncatedToDay) {
        return this.m_map.get(dateTruncatedToDay);
    }

    @Override
    public String getTooltip(Object item, Date d) {
        SimpleCalendarItem ci = (SimpleCalendarItem)item;
        return ci.getTooltipText();
    }

    @Override
    public String getLabel(Object item, Date d) {
        SimpleCalendarItem ci = (SimpleCalendarItem)item;
        return ci.getLabel();
    }

    @Override
    public Date getFromDate(Object item) {
        SimpleCalendarItem ci = (SimpleCalendarItem)item;
        return ci.getFromDate();
    }

    @Override
    public Date getToDate(Object item) {
        SimpleCalendarItem ci = (SimpleCalendarItem)item;
        return ci.getToDate();
    }

    @Override
    public Color getColor(Object item) {
        SimpleCalendarItem ci = (SimpleCalendarItem)item;
        return ci.getColor();
    }

    @Override
    public boolean isFullDay(Object item) {
        SimpleCalendarItem ci = (SimpleCalendarItem)item;
        return ci.isFullDay();
    }

    @Override
    public boolean isDraggable(Object item) {
        SimpleCalendarItem ci = (SimpleCalendarItem)item;
        return ci.isDraggable();
    }
}

