/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.icons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class BeveledButtonIcon
implements Icon {
    private AbstractButton m_button;
    private boolean m_raised;

    public BeveledButtonIcon(AbstractButton button, boolean raised) {
        this.m_button = button;
        this.m_raised = raised;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon basicIcon = this.m_button.getIcon();
        if (basicIcon != null) {
            if (this.m_raised) {
                basicIcon.paintIcon(c, g, x, y);
            } else {
                basicIcon.paintIcon(c, g, x + 1, y + 1);
            }
            g.setColor(Color.lightGray);
            g.draw3DRect(x, y, this.getIconWidth(), this.getIconHeight(), this.m_raised);
        }
    }

    @Override
    public int getIconWidth() {
        Icon basicIcon = this.m_button.getIcon();
        if (basicIcon != null) {
            return basicIcon.getIconWidth();
        }
        return 0;
    }

    @Override
    public int getIconHeight() {
        Icon basicIcon = this.m_button.getIcon();
        if (basicIcon != null) {
            return basicIcon.getIconHeight();
        }
        return 0;
    }
}

