/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.simulator;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class SwingScoutSimulator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutSimulator.class);
    private static SwingScoutSimulator instance = new SwingScoutSimulator();
    private P_AWTEventListener m_awtListener;
    private Window m_activeWindow;
    private long m_recordingStart;
    private ArrayList<Runnable> m_recordingScript;
    private ArrayList<Runnable> m_recordedScript;

    public static SwingScoutSimulator getInstance() {
        return instance;
    }

    private SwingScoutSimulator() {
    }

    public void attach() {
        if (this.m_awtListener == null) {
            this.m_awtListener = new P_AWTEventListener();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.m_awtListener, 88L);
        }
    }

    public void detach() {
        if (this.m_awtListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.m_awtListener);
            this.m_awtListener = null;
        }
    }

    public void record() {
        System.out.println("RECORD");
        this.m_recordingStart = System.currentTimeMillis();
        this.m_recordingScript = new ArrayList();
    }

    public void stop() {
        this.m_recordedScript = this.m_recordingScript;
        System.out.println("STOP");
        this.m_recordingScript = null;
    }

    public void play() {
        this.play(1);
    }

    public void play(int count) {
        final ArrayList<Runnable> fList = this.m_recordedScript;
        final int fCount = count;
        if (fList != null) {
            new Thread(){

                @Override
                public void run() {
                    SwingScoutSimulator.this.playWorker(fList, fCount);
                }
            }.start();
        }
    }

    private void playWorker(ArrayList script, int count) {
        Throwable ex = null;
        int index = 0;
        while (index < count && ex == null) {
            System.out.println("PLAY " + (index + 1) + " OF " + count);
            long startTime = System.currentTimeMillis();
            Iterator<Runnable> it = this.m_recordedScript.iterator();
            while (it.hasNext() && ex == null) {
                Runnable o = it.next();
                try {
                    long dt;
                    Runnable task;
                    if (o instanceof P_MouseTask) {
                        task = (P_MouseTask)o;
                        dt = startTime + ((P_MouseTask)task).getTimeOffset() - System.currentTimeMillis() - 10L;
                        if (dt > 0L) {
                            try {
                                Thread.sleep(dt);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        SwingUtilities.invokeAndWait(task);
                        continue;
                    }
                    if (!(o instanceof P_KeyStrokeTask)) continue;
                    task = (P_KeyStrokeTask)o;
                    dt = startTime + ((P_KeyStrokeTask)task).getTimeOffset() - System.currentTimeMillis() - 10L;
                    if (dt > 0L) {
                        try {
                            Thread.sleep(dt);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    SwingUtilities.invokeAndWait(task);
                }
                catch (Exception e) {
                    ex = e;
                }
            }
            ++index;
        }
        if (ex != null) {
            ex.printStackTrace();
        }
    }

    private Window getActiveWindow() {
        Window[] wa;
        Window w = this.m_activeWindow;
        if (w != null && (wa = w.getOwnedWindows()) != null) {
            int i = 0;
            while (i < wa.length) {
                if (wa[i].isShowing()) {
                    w = wa[i];
                    break;
                }
                ++i;
            }
        }
        return w;
    }

    private Component getDeepestComponentAt(Component parent, int x, int y) {
        if (!parent.contains(x, y)) {
            return null;
        }
        if (parent instanceof Container) {
            Component[] components = ((Container)parent).getComponents();
            int i = 0;
            while (i < components.length) {
                Component comp = components[i];
                if (comp != null && comp.isVisible()) {
                    Point loc = comp.getLocation();
                    if ((comp = comp instanceof Container ? this.getDeepestComponentAt(comp, x - loc.x, y - loc.y) : comp.getComponentAt(x - loc.x, y - loc.y)) != null && comp.isVisible()) {
                        return comp;
                    }
                }
                ++i;
            }
        }
        return parent;
    }

    private class P_AWTEventListener
    implements AWTEventListener {
        private P_AWTEventListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void eventDispatched(AWTEvent e) {
            if (e instanceof MouseEvent) {
                if (SwingScoutSimulator.this.m_recordingScript == null) return;
                MouseEvent me = (MouseEvent)e;
                switch (e.getID()) {
                    case 500: 
                    case 501: 
                    case 502: {
                        if (!me.getComponent().isShowing()) return;
                        SwingScoutSimulator.this.m_recordingScript.add(new P_MouseTask(me, me.getComponent().getLocationOnScreen(), System.currentTimeMillis() - SwingScoutSimulator.this.m_recordingStart));
                    }
                    default: {
                        return;
                    }
                }
            } else if (e instanceof KeyEvent) {
                if (SwingScoutSimulator.this.m_recordingScript == null) return;
                KeyEvent ke = (KeyEvent)e;
                switch (e.getID()) {
                    case 400: 
                    case 401: 
                    case 402: {
                        if (!ke.getComponent().isShowing() || ke.getKeyCode() == 83 && (ke.getModifiersEx() & 0x80) != 0) return;
                        SwingScoutSimulator.this.m_recordingScript.add(new P_KeyStrokeTask(ke, ke.getComponent().getLocationOnScreen(), System.currentTimeMillis() - SwingScoutSimulator.this.m_recordingStart));
                    }
                    default: {
                        return;
                    }
                }
            } else {
                if (!(e instanceof WindowEvent)) return;
                WindowEvent we = (WindowEvent)e;
                switch (e.getID()) {
                    case 205: {
                        Component c = we.getComponent();
                        while (c != null && c.isLightweight()) {
                            c = c.getParent();
                        }
                        if (c == null) return;
                        SwingScoutSimulator.this.m_activeWindow = (Window)we.getComponent();
                    }
                }
            }
        }
    }

    private class P_KeyStrokeTask
    implements Runnable {
        private KeyEvent m_event;
        private Point m_screenLocation;
        private long m_timeOffset;

        public P_KeyStrokeTask(KeyEvent e, Point screenLocation, long timeOffset) {
            this.m_event = e;
            this.m_screenLocation = screenLocation;
            this.m_timeOffset = timeOffset;
        }

        public long getTimeOffset() {
            return this.m_timeOffset;
        }

        @Override
        public void run() {
            Component c;
            Window w = SwingScoutSimulator.this.getActiveWindow();
            if (w != null && (c = SwingScoutSimulator.this.getDeepestComponentAt(w, this.m_screenLocation.x - w.getX(), this.m_screenLocation.y - w.getY())) != null) {
                KeyEvent syntEvent = new KeyEvent(c, this.m_event.getID(), System.currentTimeMillis(), this.m_event.getModifiers(), this.m_event.getKeyCode(), this.m_event.getKeyChar(), this.m_event.getKeyLocation());
                syntEvent.getComponent().dispatchEvent(syntEvent);
            }
        }
    }

    private class P_MouseTask
    implements Runnable {
        private MouseEvent m_event;
        private Point m_screenLocation;
        private long m_timeOffset;

        public P_MouseTask(MouseEvent e, Point screenLocation, long timeOffset) {
            this.m_event = e;
            this.m_screenLocation = screenLocation;
            this.m_timeOffset = timeOffset;
        }

        public long getTimeOffset() {
            return this.m_timeOffset;
        }

        @Override
        public void run() {
            Component c;
            Window w = SwingScoutSimulator.this.getActiveWindow();
            if (w != null && (c = SwingScoutSimulator.this.getDeepestComponentAt(w, this.m_screenLocation.x - w.getX(), this.m_screenLocation.y - w.getY())) != null) {
                MouseEvent syntEvent = new MouseEvent(c, this.m_event.getID(), System.currentTimeMillis(), this.m_event.getModifiers(), this.m_event.getX(), this.m_event.getY(), this.m_event.getClickCount(), this.m_event.isPopupTrigger(), this.m_event.getButton());
                syntEvent.getComponent().dispatchEvent(syntEvent);
            }
        }
    }
}

