/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.splash;

import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.splash.EmbeddedSplashWindow;
import org.eclipse.scout.rt.ui.swing.splash.ISplashWindow;
import org.eclipse.scout.rt.ui.swing.splash.SplashWindow;

public class SplashProgressMonitor
extends NullProgressMonitor {
    private final ISwingEnvironment m_env;
    private final boolean m_showPercentage;
    private int m_totalWork;
    private int m_worked;
    private String m_name1;
    private String m_name2;
    private String m_displayText;
    private ISplashWindow m_splash;

    public SplashProgressMonitor(ISwingEnvironment env) {
        this(env, false);
    }

    public SplashProgressMonitor(ISwingEnvironment env, boolean showPercentage) {
        this.m_env = env;
        this.m_showPercentage = showPercentage;
    }

    public void beginTask(String name, int totalWork) {
        this.m_name1 = name;
        this.m_totalWork = totalWork;
        this.m_worked = 0;
        this.setNameInternal();
    }

    public void worked(int work) {
        this.m_worked += work;
        this.setNameInternal();
    }

    public void subTask(String name) {
        this.m_name2 = name;
        this.setNameInternal();
    }

    public void setTaskName(String name) {
        this.m_name1 = name;
        this.m_name2 = null;
        this.setNameInternal();
    }

    private void setNameInternal() {
        this.m_displayText = "";
        if (this.m_showPercentage && this.m_totalWork > 0 && this.m_worked > 0) {
            this.m_displayText = String.valueOf(this.m_displayText) + (int)Math.floor(100.0 * (double)this.m_worked / (double)this.m_totalWork) + "% ";
        }
        this.m_displayText = this.m_name2 != null ? String.valueOf(this.m_displayText) + this.m_name2 : (this.m_name1 != null ? String.valueOf(this.m_displayText) + this.m_name1 : String.valueOf(this.m_displayText) + "...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SplashProgressMonitor.this.m_splash != null) {
                    SplashProgressMonitor.this.m_splash.setStatusText(SplashProgressMonitor.this.m_displayText);
                }
            }
        });
    }

    public void done() {
        this.hideSplash();
    }

    public void showSplash() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashProgressMonitor.this.showSplashInSwingThread();
            }
        });
    }

    private void showSplashInSwingThread() {
        if (this.m_splash == null) {
            this.m_splash = !(this.m_env.getRootFrame() instanceof JFrame) && this.m_env.getRootFrame() instanceof RootPaneContainer ? new EmbeddedSplashWindow((RootPaneContainer)((Object)this.m_env.getRootFrame())) : new SplashWindow(this.m_env.getRootFrame());
            this.m_splash.setStatusText(this.m_displayText);
            this.m_splash.showSplash();
        }
    }

    public void hideSplash() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashProgressMonitor.this.hideSplashInSwingThread();
            }
        });
    }

    private void hideSplashInSwingThread() {
        if (this.m_splash != null) {
            this.m_splash.disposeSplash();
            this.m_splash = null;
        }
    }
}

