/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.DesktopManager;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.JInternalFrameEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.ColumnSplitStrategy;
import org.eclipse.scout.rt.ui.swing.window.desktop.ISwingScoutDesktop;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.IMultiSplitStrategy;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.MultiSplitDesktopManager;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.MultiSplitLayout;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.MultiSplitLayoutConstraints;

public class SwingScoutDesktop
extends SwingScoutComposite<IDesktop>
implements ISwingScoutDesktop {
    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        JDesktopPane swingDesktop = new JDesktopPane();
        this.setSwingField(swingDesktop);
        swingDesktop.setDesktopManager(new MultiSplitDesktopManager());
        IMultiSplitStrategy columnSplitStrategy = this.createMultiSplitStrategy();
        MultiSplitLayout layout = new MultiSplitLayout(columnSplitStrategy);
        swingDesktop.setLayout(layout);
        swingDesktop.setOpaque(true);
        swingDesktop.setCursor(null);
        swingDesktop.setFocusCycleRoot(false);
        swingDesktop.setFocusTraversalPolicy(null);
        swingDesktop.getInputMap(1).put(SwingUtility.createKeystroke("shift ctrl TAB"), "selectPreviousFrame");
        swingDesktop.getActionMap().put("selectNextFrame", new P_SwingTabFrameAction(1));
        swingDesktop.getActionMap().put("selectPreviousFrame", new P_SwingTabFrameAction(-1));
        SwingUtility.installDevelopmentShortcuts(this.getSwingDesktopPane());
    }

    @Override
    public JDesktopPane getSwingField() {
        return (JDesktopPane)super.getSwingField();
    }

    @Override
    public JDesktopPane getSwingDesktopPane() {
        return this.getSwingField();
    }

    private void handleSwingTabAction(int delta) {
        JInternalFrame[] frames = this.getSwingDesktopPane().getAllFrames();
        TreeMap<Integer, JInternalFrame> sortedMap = new TreeMap<Integer, JInternalFrame>();
        JInternalFrame[] jInternalFrameArray = frames;
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame f = jInternalFrameArray[n2];
            if (f.isVisible()) {
                int tabIndex = f.getX() * 100000 + f.getY();
                if (delta < 0) {
                    tabIndex = -tabIndex;
                }
                sortedMap.put(tabIndex, f);
            }
            ++n2;
        }
        JInternalFrame next = null;
        if (sortedMap.size() > 0) {
            ArrayList list = new ArrayList(sortedMap.values());
            int nextIndex = 0;
            JInternalFrame selectedFrame = this.getSwingDesktopPane().getSelectedFrame();
            if (selectedFrame != null) {
                nextIndex = (list.indexOf(selectedFrame) + 1) % list.size();
            }
            next = (JInternalFrame)list.get(nextIndex);
        }
        if (next != null) {
            try {
                next.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    @Override
    public void addView(JInternalFrameEx f, Object constraints) {
        MultiSplitLayoutConstraints mc = (MultiSplitLayoutConstraints)constraints;
        f.setTabIndex(mc.tabIndex);
        f.setVisible(true);
        this.getSwingDesktopPane().add((Component)f, mc);
        DesktopManager dm = this.getSwingDesktopPane().getDesktopManager();
        if (dm instanceof MultiSplitDesktopManager) {
            ((MultiSplitDesktopManager)dm).fitFrames(new JInternalFrame[]{f});
        }
        this.getSwingDesktopPane().revalidate();
        this.getSwingDesktopPane().repaint();
    }

    @Override
    public void removeView(JInternalFrameEx f) {
        this.getSwingDesktopPane().getDesktopManager().closeFrame(f);
        f.setVisible(false);
        this.getSwingDesktopPane().remove(f);
    }

    protected IMultiSplitStrategy createMultiSplitStrategy() {
        return new ColumnSplitStrategy(ClientUIPreferences.getInstance((IClientSession)this.getSwingEnvironment().getScoutSession()));
    }

    private class P_SwingTabFrameAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private int m_delta;

        public P_SwingTabFrameAction(int delta) {
            this.m_delta = delta;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutDesktop.this.handleSwingTabAction(this.m_delta);
        }
    }
}

