/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.layout;

import org.eclipse.scout.rt.ui.swing.window.desktop.layout.IMultiSplitStrategy;

public class DefaultColumnSplitStrategy
implements IMultiSplitStrategy {
    private int m_span = 1000;
    private int[][] m_location;
    private boolean m_initialValues;

    public DefaultColumnSplitStrategy() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[4];
        nArray[1] = 250;
        nArray[2] = 750;
        nArray[3] = 1000;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 250;
        nArray2[2] = 750;
        nArray2[3] = 1000;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 250;
        nArray3[2] = 750;
        nArray3[3] = 1000;
        nArrayArray[2] = nArray3;
        this.m_location = nArrayArray;
        this.m_initialValues = true;
    }

    @Override
    public void updateSpan(int newSpan) {
        int oldSpan = this.m_span;
        if (oldSpan != newSpan) {
            this.m_span = newSpan;
            int r = 0;
            while (r < 3) {
                this.m_location[r][3] = this.m_span;
                if (this.m_initialValues) {
                    this.m_location[r][1] = 250;
                    this.m_location[r][2] = this.m_span - 250;
                    if (this.m_location[r][1] + 20 > this.m_location[r][2]) {
                        this.m_location[r][1] = this.m_span / 2 - 10;
                        this.m_location[r][2] = this.m_span / 2 + 10;
                    }
                } else if (newSpan > oldSpan) {
                    int[] nArray = this.m_location[r];
                    nArray[2] = nArray[2] + (newSpan - oldSpan);
                } else {
                    int dSpan = oldSpan - newSpan;
                    dSpan = Math.min(dSpan, this.m_location[r][2] - this.m_location[r][1]);
                    dSpan = Math.max(dSpan, 0);
                    int[] nArray = this.m_location[r];
                    nArray[2] = nArray[2] - dSpan;
                }
                ++r;
            }
        }
    }

    @Override
    public int getSplitLocation(int row, int col) {
        return this.m_location[row][col];
    }

    @Override
    public void setSplitLocation(int row, int col, int newLocation) {
        if (col == 0 || col == 3) {
            return;
        }
        if (this.m_location[row][col - 1] + 20 < newLocation && newLocation + 20 < this.m_location[row][col + 1]) {
            this.m_location[row][col] = newLocation;
            this.m_initialValues = false;
        }
    }
}

