/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JInternalFrame;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.Cell;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.CellSplit;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.DefaultColumnSplitStrategy;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.IMultiSplitStrategy;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.MultiSplitLayoutConstraints;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.ViewModel;

public class MultiSplitLayout
extends AbstractLayoutManager2 {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MultiSplitLayout.class);
    private static final String CONSTRAINT_PROPERTY_NAME = "MultiSplitLayoutConstraints";
    private static final int UNLIMITED = 10240;
    private final Cell[][] m_cells = new Cell[3][3];
    private final CellSplit[][] m_rowSplits = new CellSplit[4][3];
    private final CellSplit[][] m_colSplits = new CellSplit[3][4];
    private final ViewModel m_model;
    private final MouseListener m_mouseListener;
    private final IMultiSplitStrategy m_columnSplitStrategy;
    private Dimension[] m_sizes;

    public MultiSplitLayout(IMultiSplitStrategy columnSplitStrategy) {
        int c;
        this.m_columnSplitStrategy = columnSplitStrategy != null ? columnSplitStrategy : new DefaultColumnSplitStrategy();
        int r = 0;
        while (r < this.m_cells.length) {
            c = 0;
            while (c < this.m_cells[r].length) {
                this.m_cells[r][c] = new Cell(r, c, true);
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.m_rowSplits.length) {
            c = 0;
            while (c < this.m_rowSplits[r].length) {
                int[] top = new int[]{r - 1, c};
                int[] bottom = new int[]{r, c};
                if (r == 0) {
                    top = null;
                } else if (r == this.m_rowSplits.length - 1) {
                    bottom = null;
                }
                this.m_rowSplits[r][c] = new CellSplit(true, r, c, r == 0 || r == this.m_rowSplits.length - 1, top != null ? this.m_cells[top[0]][top[1]] : null, bottom != null ? this.m_cells[bottom[0]][bottom[1]] : null, 200 * r, null);
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.m_colSplits.length) {
            c = 0;
            while (c < this.m_colSplits[r].length) {
                int[] left = new int[]{r, c - 1};
                int[] right = new int[]{r, c};
                if (c == 0) {
                    left = null;
                } else if (c == this.m_colSplits[r].length - 1) {
                    right = null;
                }
                this.m_colSplits[r][c] = new CellSplit(false, r, c, c == 0 || c == this.m_colSplits[r].length - 1, left != null ? this.m_cells[left[0]][left[1]] : null, right != null ? this.m_cells[right[0]][right[1]] : null, 0, this.m_columnSplitStrategy);
                ++c;
            }
            ++r;
        }
        this.m_model = new ViewModel();
        this.m_mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MultiSplitLayout.this.m_model.setMousePressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MultiSplitLayout.this.m_model.setMousePressed(false);
            }
        };
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public void addLayoutComponent(Component comp, Object cons) {
        if (comp instanceof JInternalFrame) {
            JInternalFrame f = (JInternalFrame)comp;
            f.addMouseListener(this.m_mouseListener);
            if (cons == null) {
                cons = f.getClientProperty(CONSTRAINT_PROPERTY_NAME);
            }
            if (cons instanceof MultiSplitLayoutConstraints) {
                f.putClientProperty(CONSTRAINT_PROPERTY_NAME, cons);
                MultiSplitLayoutConstraints mcons = (MultiSplitLayoutConstraints)cons;
                this.m_cells[mcons.row][mcons.col].addView(comp, mcons.distributionMap);
            } else {
                throw new IllegalArgumentException("expected layout constraints of type MultiSplitLayoutConstraints for " + f.getTitle());
            }
        }
        this.invalidateLayout();
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp instanceof JInternalFrame) {
            comp.removeMouseListener(this.m_mouseListener);
            int r = 0;
            while (r < this.m_cells.length) {
                int c = 0;
                while (c < this.m_cells[r].length) {
                    this.m_cells[r][c].removeView(comp);
                    ++c;
                }
                ++r;
            }
        }
        this.invalidateLayout();
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    protected void validateLayout(Container parent) {
        int c = 0;
        while (c < this.m_rowSplits[0].length) {
            int curHeight = this.m_rowSplits[this.m_rowSplits.length - 1][c].getLocation();
            int height = parent.getHeight();
            if (height > curHeight) {
                int dy = height - curHeight;
                int k = this.m_rowSplits.length - 2;
                while (k < this.m_rowSplits.length) {
                    CellSplit split = this.m_rowSplits[k][c];
                    split.setLocation(split.getLocation() + dy);
                    ++k;
                }
            } else if (height < curHeight) {
                int maxLoc = height;
                int r = this.m_rowSplits.length - 1;
                while (r > 0) {
                    if (this.m_rowSplits[r][c].getLocation() > maxLoc) {
                        this.m_rowSplits[r][c].setLocation(maxLoc);
                        maxLoc = Math.max(0, maxLoc - 20);
                        --r;
                        continue;
                    }
                    break;
                }
            }
            ++c;
        }
        this.m_columnSplitStrategy.updateSpan(parent.getWidth());
        this.m_model.rebuild(this.m_cells, this.m_rowSplits, this.m_colSplits);
        this.m_sizes = new Dimension[3];
        Insets insets = parent.getInsets();
        Dimension minSize = this.m_model.getMinimumSize();
        minSize.width += insets.left + insets.right;
        minSize.height += insets.top + insets.bottom;
        this.m_sizes[0] = minSize;
        this.m_sizes[1] = new Dimension(Math.max(800, this.m_sizes[0].width), Math.max(600, this.m_sizes[0].height));
        this.m_sizes[2] = new Dimension(10240, 10240);
    }

    @Override
    protected Dimension getLayoutSize(Container parent, int sizeflag) {
        return this.m_sizes[sizeflag];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        this.verifyLayout(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component comp;
            JInternalFrame maximizedFrame = null;
            int i = 0;
            int ni = parent.getComponentCount();
            while (i < ni) {
                comp = parent.getComponent(i);
                if (comp instanceof JInternalFrame && ((JInternalFrame)comp).isMaximum()) {
                    if (comp.isVisible()) {
                        maximizedFrame = (JInternalFrame)comp;
                        break;
                    }
                    try {
                        ((JInternalFrame)comp).setMaximum(false);
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
            if (maximizedFrame == null) {
                i = 0;
                ni = parent.getComponentCount();
                while (i < ni) {
                    comp = parent.getComponent(i);
                    if (comp instanceof JInternalFrame) {
                        Rectangle r = this.m_model.getBoundsFor((JInternalFrame)comp);
                        if (r.x != comp.getX() || r.y != comp.getY() || r.width != comp.getWidth() || r.height != comp.getHeight()) {
                            comp.setBounds(r);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public ViewModel getModel(Container parent) {
        this.verifyLayout(parent);
        return this.m_model;
    }
}

