/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJViewTabsBar;

public class JViewTabsBar
extends AbstractJViewTabsBar {
    private static final long serialVersionUID = 1L;
    private final ISwingEnvironment m_env;

    public JViewTabsBar(ISwingEnvironment env) {
        this.m_env = env;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
    }

    @Override
    public void rebuild(IDesktop desktop) {
        this.removeAll();
        JToolBar swingToolBar = new JToolBar(0);
        swingToolBar.setFloatable(false);
        swingToolBar.setOpaque(false);
        swingToolBar.setBorder(new EmptyBorder(0, 3, 0, 0));
        swingToolBar.setLayout(new GridBagLayout());
        IViewButton[] iViewButtonArray = desktop.getViewButtons();
        int n = iViewButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewButton scoutViewButton = iViewButtonArray[n2];
            ISwingScoutAction<IViewButton> swingScoutViewButton = this.createSwingScoutViewButton(scoutViewButton);
            if (swingScoutViewButton != null) {
                AbstractButton swingButton = (AbstractButton)swingScoutViewButton.getSwingField();
                this.addActiveTabListener(swingButton);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 3;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(0, 0, 0, 2);
                swingToolBar.add((Component)swingButton, gbc);
            }
            ++n2;
        }
        JPanel filler = new JPanel();
        filler.setPreferredSize(new Dimension(-1, 0));
        filler.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)filler, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.add((Component)swingToolBar, gbc);
        filler = new JPanel();
        filler.setOpaque(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)filler, gbc);
    }

    protected ISwingEnvironment getSwingEnvironment() {
        return this.m_env;
    }

    private ISwingScoutAction<IViewButton> createSwingScoutViewButton(IViewButton scoutViewButton) {
        return this.getSwingEnvironment().createAction(this, (IAction)scoutViewButton);
    }
}

