/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironmentListener;
import org.eclipse.scout.rt.ui.swt.SwtEnvironmentEvent;
import org.eclipse.scout.rt.ui.swt.SwtMenuUtility;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.CompoundContributionItem;

public abstract class AbstractSwtMenuContributionItem
extends CompoundContributionItem {
    private List<IContributionItem> m_currentItems;
    private ISwtEnvironmentListener m_swtEnvironmentListener = new SwtEnvironmentListener();

    public AbstractSwtMenuContributionItem() {
        this.getSwtEnvironment().addEnvironmentListener(this.m_swtEnvironmentListener);
    }

    public void dispose() {
        if (this.m_swtEnvironmentListener != null) {
            this.getSwtEnvironment().removeEnvironmentListener(this.m_swtEnvironmentListener);
        }
        super.dispose();
    }

    protected abstract ISwtEnvironment getSwtEnvironment();

    protected final IContributionItem[] getContributionItems() {
        IContributionItem[] items = new IContributionItem[]{};
        if (this.getSwtEnvironment().isInitialized()) {
            items = this.collectContributionItems();
        }
        this.m_currentItems = new LinkedList<IContributionItem>(Arrays.asList(items));
        return items;
    }

    protected IContributionItem[] collectContributionItems() {
        return SwtMenuUtility.getMenuContribution(this.getSwtEnvironment().getClientSession().getDesktop().getMenus(), this.getSwtEnvironment());
    }

    public List<IContributionItem> getCurrentContributionItems() {
        return this.m_currentItems;
    }

    public void fill(Menu menu, int index) {
        super.fill(menu, index);
        this.updateChilds();
    }

    public void update() {
        if (this.getParent() instanceof IMenuManager) {
            IMenuManager menuMgr = (IMenuManager)this.getParent();
            menuMgr.updateAll(true);
        }
    }

    protected void updateChilds() {
        if (this.getCurrentContributionItems() != null) {
            for (IContributionItem contributionItem : this.getCurrentContributionItems()) {
                if (!(contributionItem instanceof IMenuManager)) continue;
                IMenuManager childManager = (IMenuManager)contributionItem;
                childManager.updateAll(true);
            }
        }
    }

    protected class SwtEnvironmentListener
    implements ISwtEnvironmentListener {
        protected SwtEnvironmentListener() {
        }

        @Override
        public void environmentChanged(SwtEnvironmentEvent e) {
            if (e.getType() == 2) {
                AbstractSwtMenuContributionItem.this.update();
            }
        }
    }
}

