/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.RunnableWithData;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutAction;
import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarModel;
import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarViewEvent;
import org.eclipse.scout.rt.ui.swt.basic.calendar.ICalendarViewListener;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.scout.rt.ui.swt.form.fields.calendar.SwtScoutCalendarField;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SwtScoutCalendar
extends SwtCalendar {
    private ICalendar m_scoutCalendarModel;
    private Lock m_singleObserverLock = new ReentrantLock();
    private SwtScoutCalendarField m_field;
    private OptimisticLock m_propertyChangeLock = new OptimisticLock();
    private P_ScoutCalendarPropertyListener m_activePropertyListener;

    public SwtScoutCalendar(Composite parent, int style, SwtScoutCalendarField field) {
        super(parent, style);
        this.m_field = field;
        P_SwtCalendarListener cl = new P_SwtCalendarListener();
        this.addCalendarViewListener(cl);
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
            }
        });
    }

    public void setScoutCalendarModel(ICalendar calendarModel) {
        this.m_scoutCalendarModel = calendarModel;
        this.setModel(new P_SwtCalendarModel(calendarModel.getComponents()));
        this.setDisplayMode(calendarModel.getDisplayMode());
        this.setCondensedMode(calendarModel.isDisplayCondensed());
        Calendar selectedDate = Calendar.getInstance();
        if (calendarModel.getSelectedDate() != null) {
            selectedDate.setTime(calendarModel.getSelectedDate());
        }
        this.setViewDate(selectedDate);
        this.m_activePropertyListener = new P_ScoutCalendarPropertyListener();
        this.m_scoutCalendarModel.addPropertyChangeListener((PropertyChangeListener)this.m_activePropertyListener);
    }

    @Override
    public void showGeneralContextMenu(IMenuManager manager) {
        IMenu[] scoutMenus = ((ICalendarField)this.m_field.getScoutObject()).getCalendar().getUIFacade().fireNewPopupFromUI();
        if (scoutMenus != null) {
            IMenu[] iMenuArray = scoutMenus;
            int n = scoutMenus.length;
            int n2 = 0;
            while (n2 < n) {
                IMenu menuItem = iMenuArray[n2];
                if (menuItem instanceof IMenu) {
                    if (menuItem.isSeparator()) {
                        manager.add((IContributionItem)new Separator());
                    } else {
                        manager.add((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)menuItem, this.m_field.getEnvironment(), 1).getSwtAction());
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void showItemContextMenu(IMenuManager manager, Object item) {
        IMenu[] scoutMenus = ((ICalendarField)this.m_field.getScoutObject()).getCalendar().getUIFacade().fireComponentPopupFromUI();
        if (scoutMenus != null) {
            IMenu[] iMenuArray = scoutMenus;
            int n = scoutMenus.length;
            int n2 = 0;
            while (n2 < n) {
                IMenu menuItem = iMenuArray[n2];
                if (menuItem instanceof IMenu) {
                    if (menuItem.isSeparator()) {
                        manager.add((IContributionItem)new Separator());
                    } else {
                        manager.add((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)menuItem, this.m_field.getEnvironment(), 1).getSwtAction());
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void setDisplayMode(final int newMode) {
        super.setDisplayMode(newMode);
        if (this.m_singleObserverLock.tryLock()) {
            try {
                JobEx job = this.m_field.getEnvironment().invokeScoutLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutCalendar.this.m_scoutCalendarModel != null) {
                            SwtScoutCalendar.this.m_scoutCalendarModel.setDisplayMode(newMode);
                        }
                    }
                }, 0L);
                try {
                    job.join(2345L);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                this.m_singleObserverLock.unlock();
            }
        }
    }

    @Override
    public void setCondensedMode(final boolean condensed) {
        super.setCondensedMode(condensed);
        if (this.m_singleObserverLock.tryLock()) {
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutCalendar.this.m_scoutCalendarModel != null) {
                            SwtScoutCalendar.this.m_scoutCalendarModel.setDisplayCondensed(condensed);
                        }
                    }
                };
                JobEx job = this.m_field.getEnvironment().invokeScoutLater(r, 0L);
                try {
                    job.join(2345L);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                this.m_singleObserverLock.unlock();
            }
        }
    }

    @Override
    public void setSelectedDateFromUI(final Calendar c) {
        super.setSelectedDateFromUI(c);
        if (this.m_scoutCalendarModel != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SwtScoutCalendar.this.m_scoutCalendarModel.setSelectedDate(c.getTime());
                }
            };
            this.m_field.getEnvironment().invokeScoutLater(r, 0L);
        }
    }

    private void setSelectedDateFromScout(Calendar c) {
        super.setSelectedDate(c);
    }

    @Override
    protected void shiftViewDate(int type, int amount, boolean fireNotification) {
        super.shiftViewDate(type, amount, fireNotification);
        if (this.m_scoutCalendarModel != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SwtScoutCalendar.this.m_scoutCalendarModel.setViewRange(SwtScoutCalendar.this.getViewDateStart().getTime(), SwtScoutCalendar.this.getViewDateEnd().getTime());
                }
            };
            JobEx job = this.m_field.getEnvironment().invokeScoutLater(r, 0L);
            try {
                job.join(2345L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        try {
            if (this.m_propertyChangeLock.acquire()) {
                if (name.equals("displayMode")) {
                    int i = ((Number)newValue).intValue();
                    this.setDisplayMode(i);
                    this.fireViewDateChanged();
                    this.refreshLayout();
                } else if (name.equals("displayCondensed")) {
                    boolean b = (Boolean)newValue;
                    this.setCondensedMode(b);
                    this.refreshLayout();
                } else if (name.equals("selectedDate")) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)newValue);
                    this.setSelectedDateFromScout(cal);
                    this.setViewDate(cal);
                    this.fireViewDateChanged();
                    this.refreshLayout();
                } else if (name.equals("viewRange")) {
                    this.fireViewDateChanged();
                    this.refreshLayout();
                } else if (name.equals("components")) {
                    this.setCalendarComponentsFromScout((CalendarComponent[])newValue);
                } else if (!name.equals("selectedComponent")) {
                    if (name.equals("loadInProgress")) {
                        this.setLoadInProgressFromScout((Boolean)newValue);
                    } else {
                        LOG.debug("Following property not handled: " + name + " -> " + (newValue == null ? "none" : newValue.toString()));
                    }
                }
            }
        }
        finally {
            this.m_propertyChangeLock.release();
        }
    }

    private void setLoadInProgressFromScout(boolean b) {
        if (b) {
            this.setCursor(new Cursor((Device)SwtColors.getStandardDisplay(), 1));
        } else {
            this.setCursor(null);
        }
    }

    public SwtCalendar getSwtCalendar() {
        return this;
    }

    public void setCalendarComponentsFromScout(CalendarComponent[] c) {
        this.getSwtCalendar().setModel(new P_SwtCalendarModel(c));
    }

    protected class P_ScoutCalendarPropertyListener
    implements PropertyChangeListener,
    WeakEventListener {
        protected P_ScoutCalendarPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            RunnableWithData r = new RunnableWithData(){

                public void run() {
                    PropertyChangeEvent e2 = (PropertyChangeEvent)this.getData("event");
                    SwtScoutCalendar.this.handleScoutPropertyChange(e2.getPropertyName(), e2.getNewValue());
                }
            };
            r.setData("event", (Object)e);
            SwtScoutCalendar.this.m_field.getEnvironment().invokeSwtLater((Runnable)r);
        }
    }

    private class P_SwtCalendarListener
    implements ICalendarViewListener {
        private P_SwtCalendarListener() {
        }

        @Override
        public void viewChanged(final CalendarViewEvent e) {
            switch (e.getType()) {
                case 30: {
                    try {
                        if (SwtScoutCalendar.this.m_propertyChangeLock.acquire()) {
                            final Date d = SwtScoutCalendar.this.getSelectedDate().getTime();
                            final CalendarComponent cc = (CalendarComponent)SwtScoutCalendar.this.getSelectedItem();
                            RunnableWithData r = new RunnableWithData(){

                                public void run() {
                                    if (cc != null) {
                                        ((ICalendarField)SwtScoutCalendar.this.m_field.getScoutObject()).getCalendar().getUIFacade().setSelectionFromUI(d, cc);
                                    }
                                }
                            };
                            SwtScoutCalendar.this.m_field.getEnvironment().invokeScoutLater((Runnable)r, 2345L);
                        }
                    }
                    finally {
                        SwtScoutCalendar.this.m_propertyChangeLock.release();
                    }
                    SwtScoutCalendar.this.refreshLayout();
                    break;
                }
                case 10: {
                    RunnableWithData t = new RunnableWithData(){

                        public void run() {
                            ((ICalendarField)SwtScoutCalendar.this.m_field.getScoutObject()).getCalendar().getUIFacade().setVisibleRangeFromUI(e.getViewDateStart(), e.getViewDateEnd());
                        }
                    };
                    SwtScoutCalendar.this.m_field.getEnvironment().invokeScoutLater((Runnable)t, 2345L);
                }
            }
        }
    }

    private class P_SwtCalendarModel
    implements CalendarModel {
        private CalendarComponent[] m_components;
        private HashMap<Date, Collection<CalendarComponent>> m_dayMap;

        public P_SwtCalendarModel(CalendarComponent[] components) {
            this.m_components = components;
            this.m_dayMap = new HashMap();
            CalendarComponent[] calendarComponentArray = this.m_components;
            int n = this.m_components.length;
            int n2 = 0;
            while (n2 < n) {
                CalendarComponent comp = calendarComponentArray[n2];
                Date[] dateArray = comp.getCoveredDays();
                int n3 = dateArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Date day = dateArray[n4];
                    Collection<CalendarComponent> list = this.m_dayMap.get(day);
                    if (list == null) {
                        list = new ArrayList<CalendarComponent>();
                        this.m_dayMap.put(day, list);
                    }
                    list.add(comp);
                    ++n4;
                }
                ++n2;
            }
        }

        @Override
        public Collection<CalendarComponent> getItemsAt(Date dateTruncatedToDay) {
            return this.m_dayMap.get(dateTruncatedToDay);
        }

        @Override
        public String getTooltip(Object item, Date d) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getTooltip(d);
        }

        @Override
        public String getLabel(Object item, Date d) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getLabel(d);
        }

        @Override
        public Date getFromDate(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getFromDate();
        }

        @Override
        public Date getToDate(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getToDate();
        }

        @Override
        public Color getColor(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return SwtColors.getInstance().getColor(comp.getCell().getBackgroundColor());
        }

        @Override
        public boolean isFullDay(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.isFullDay();
        }

        @Override
        public boolean isDraggable(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.isDraggable();
        }

        @Override
        public void moveItem(Object item, Date newDate) {
            CalendarComponent comp = (CalendarComponent)item;
            ((ICalendarField)SwtScoutCalendar.this.m_field.getScoutObject()).getCalendar().getUIFacade().fireComponentMovedFromUI(comp, newDate);
        }
    }
}

