/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.busy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.scout.rt.ui.swt.window.desktop.editor.AbstractScoutEditorPart;
import org.eclipse.scout.rt.ui.swt.window.desktop.view.AbstractScoutView;
import org.eclipse.scout.rt.ui.swt.window.dialog.SwtScoutDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class SwtBusyUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtBusyUtility.class);

    private SwtBusyUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showBusyIndicator(final Display display, final IRunnableWithProgress runnable, IProgressMonitor monitor) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run(IProgressMonitor monitor2) throws InvocationTargetException, InterruptedException {
                                        try {
                                            runnable.run(monitor2);
                                        }
                                        catch (Throwable throwable) {
                                            Object object = lock;
                                            synchronized (object) {
                                                lock.notifyAll();
                                            }
                                            throw throwable;
                                        }
                                        Object object = lock;
                                        synchronized (object) {
                                            lock.notifyAll();
                                        }
                                    }
                                }, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)display);
                            }
                            catch (Throwable t) {
                                LOG.warn("run modal context", t);
                            }
                        }
                    });
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showWorkbenchIndicator(Display display, final IRunnableWithProgress runnable) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow == null) {
                        return;
                    }
                    try {
                        activeWorkbenchWindow.run(true, true, new IRunnableWithProgress(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run(IProgressMonitor workbenchJobMonitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    runnable.run(workbenchJobMonitor);
                                }
                                catch (Throwable throwable) {
                                    Object object = lock;
                                    synchronized (object) {
                                        lock.notifyAll();
                                    }
                                    throw throwable;
                                }
                                Object object = lock;
                                synchronized (object) {
                                    lock.notifyAll();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        LOG.warn("Exception while showing workbench busy indicator.", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Exception while showing workbench busy indicator.", (Throwable)e);
                    }
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean isDialogPart(ISwtScoutPart part) {
        return part instanceof SwtScoutDialog;
    }

    public static boolean isViewOrEditorPart(ISwtScoutPart part) {
        return part instanceof AbstractScoutView || part instanceof AbstractScoutEditorPart;
    }

    public static List<ISwtScoutPart> findAffectedParts(ISwtEnvironment env) {
        ArrayList<ISwtScoutPart> candidateParts = new ArrayList<ISwtScoutPart>();
        for (ISwtScoutPart part : env.getOpenFormParts()) {
            if (!SwtBusyUtility.isDialogPart(part) && !SwtBusyUtility.isViewOrEditorPart(part)) continue;
            candidateParts.add(part);
        }
        ArrayList<ISwtScoutPart> affectedParts = new ArrayList<ISwtScoutPart>();
        for (ISwtScoutPart part : candidateParts) {
            if (!part.isActive() || !SwtBusyUtility.isDialogPart(part)) continue;
            affectedParts.add(part);
            return affectedParts;
        }
        for (ISwtScoutPart part : candidateParts) {
            if (!part.isActive() || !SwtBusyUtility.isDialogPart(part)) continue;
            affectedParts.add(part);
            return affectedParts;
        }
        for (ISwtScoutPart part : candidateParts) {
            if (!part.isActive() || !SwtBusyUtility.isViewOrEditorPart(part)) continue;
            affectedParts.addAll(candidateParts);
            affectedParts.remove(part);
            affectedParts.add(0, part);
            return affectedParts;
        }
        affectedParts.add(null);
        affectedParts.addAll(candidateParts);
        return affectedParts;
    }
}

