/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.concurrency;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.concurrency.LoopDetector;
import org.eclipse.swt.widgets.Display;

public class SwtScoutSynchronizer {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutSynchronizer.class);
    private final ISwtEnvironment m_env;
    private final Display m_swtQueue;
    private LoopDetector m_loopDetector;

    public SwtScoutSynchronizer(ISwtEnvironment env) {
        this.m_env = env;
        this.m_swtQueue = this.m_env.getDisplay();
        this.m_loopDetector = new LoopDetector(5000L, 2500, 10);
    }

    private boolean isModelThread() {
        return ClientSyncJob.getCurrentSession() == this.m_env.getClientSession() && ClientSyncJob.isSyncClientJob();
    }

    public JobEx invokeScoutLater(final Runnable j, long cancelTimeout) {
        if (this.isModelThread()) {
            LOG.warn("queueing scout runnable into scout thread: " + j);
            j.run();
            return null;
        }
        if (Thread.currentThread() != this.m_swtQueue.getThread()) {
            throw new IllegalStateException("queueing scout runnable from outside swt thread: " + j);
        }
        this.m_loopDetector.addSample();
        if (this.m_loopDetector.isArmed()) {
            LOG.warn("loop detection: " + j, (Throwable)new Exception("Loop detected"));
            return null;
        }
        final long deadLine = cancelTimeout > 0L ? System.currentTimeMillis() + cancelTimeout : -1L;
        ClientSyncJob eclipseJob = new ClientSyncJob("Swing post::" + j, this.m_env.getClientSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                if (deadLine < 0L || deadLine > System.currentTimeMillis()) {
                    j.run();
                }
            }
        };
        eclipseJob.schedule();
        return eclipseJob;
    }

    public void invokeSwtLater(Runnable j) {
        if (Thread.currentThread() == this.m_swtQueue.getThread()) {
            LOG.warn("queueing swt runnable into swt thread: " + j);
            j.run();
            return;
        }
        if (ClientSyncJob.getCurrentSession() != this.m_env.getClientSession()) {
            throw new IllegalStateException("queueing swt runnable from outside scout thread: " + j);
        }
        if (!this.isModelThread()) {
            throw new IllegalStateException("queueing swt runnable from outside scout thread: " + j);
        }
        this.m_swtQueue.asyncExec(j);
    }
}

