/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext.table;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableEx
extends Table {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableEx.class);
    private static final int TEXT_MARGIN_Y = 1;
    private static final int TEXT_MARGIN_X = 6;
    private static final int IMAGE_TEXT_PADDING = 1;
    private P_MouseHoverListener m_mouseHoverListener = new P_MouseHoverListener();
    private boolean m_readOnly;
    private boolean m_multiline;
    private int m_insideSetTopIndex;

    public TableEx(Composite parent, int style, boolean multiline) {
        super(parent, style);
        this.m_multiline = multiline;
        if (multiline) {
            P_MultilineListener multilineListener = new P_MultilineListener();
            this.addListener(41, multilineListener);
            this.addListener(40, multilineListener);
            this.addListener(42, multilineListener);
        }
    }

    protected void checkSubclass() {
    }

    public void setTopIndex(int index) {
        if (this.m_insideSetTopIndex > 0) {
            return;
        }
        try {
            ++this.m_insideSetTopIndex;
            super.setTopIndex(index);
        }
        finally {
            --this.m_insideSetTopIndex;
        }
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point size = super.computeSize(hint, hint2, changed);
        TableColumn[] columns = this.getColumns();
        if (columns != null) {
            int x = 0;
            TableColumn[] tableColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                x += col.getWidth();
                ++n2;
            }
            size.x = x += columns.length * this.getGridLineWidth();
        }
        return size;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.m_readOnly != readOnly) {
            this.m_readOnly = readOnly;
        }
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.setForeground(null);
        } else {
            this.setForeground(this.getDisplay().getSystemColor(15));
        }
    }

    private class P_MouseHoverListener
    extends MouseTrackAdapter
    implements MouseMoveListener {
        private TableItem m_mouseHoverItem;

        private P_MouseHoverListener() {
        }

        public void mouseMove(MouseEvent e) {
            TableItem item = TableEx.this.getItem(new Point(e.x, e.y));
            if (item != this.m_mouseHoverItem && item != null) {
                Rectangle b;
                if (this.m_mouseHoverItem != null && !this.m_mouseHoverItem.isDisposed()) {
                    this.m_mouseHoverItem.setBackground(null);
                    b = this.m_mouseHoverItem.getBounds();
                    this.redrawInternal(b);
                }
                this.m_mouseHoverItem = item;
                this.m_mouseHoverItem.setBackground(TableEx.this.getDisplay().getSystemColor(19));
                b = this.m_mouseHoverItem.getBounds();
                this.redrawInternal(b);
            }
        }

        public void mouseExit(MouseEvent e) {
            if (this.m_mouseHoverItem != null && !this.m_mouseHoverItem.isDisposed()) {
                this.m_mouseHoverItem.setBackground(null);
                Rectangle b = this.m_mouseHoverItem.getBounds();
                this.redrawInternal(b);
            }
        }

        private void redrawInternal(final Rectangle b) {
            TableEx.this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TableEx.this.isDisposed()) {
                        TableEx.this.redraw(b.x, b.y, b.width, b.height, false);
                    }
                }
            });
        }
    }

    private class P_MultilineListener
    implements Listener {
        private P_MultilineListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 41: {
                    Point mSize = new Point(0, 0);
                    TableItem mitem = (TableItem)event.item;
                    Image img = mitem.getImage(event.index);
                    if (img != null) {
                        Rectangle imgBounds = img.getBounds();
                        mSize.x += imgBounds.width + 2;
                        mSize.y = Math.max(mSize.y, imgBounds.height + 2);
                    }
                    String mtext = mitem.getText(event.index);
                    Point textSize = TableEx.this.m_multiline ? event.gc.textExtent(mtext) : event.gc.stringExtent(mtext);
                    mSize.x += textSize.x + 12;
                    mSize.y = Math.max(mSize.y, textSize.y + 2);
                    event.width = mSize.x;
                    event.height = Math.max(event.height, mSize.y);
                    break;
                }
                case 42: {
                    TableItem pitem = (TableItem)event.item;
                    String ptext = pitem.getText(event.index);
                    int align = 16384;
                    TableColumn tc = TableEx.this.getColumn(event.index);
                    if (tc != null) {
                        align = tc.getStyle() & 0x1024000;
                    }
                    Rectangle itemBounds = pitem.getBounds(event.index);
                    int xImageOffset = itemBounds.x;
                    int xTextOffset = xImageOffset + 6;
                    int yOffset = itemBounds.y + 1;
                    Point textExtent = event.gc.stringExtent(ptext);
                    Image pImg = pitem.getImage(event.index);
                    Rectangle contentBounds = null;
                    if (pImg != null) {
                        contentBounds = pImg.getBounds();
                        if (textExtent.x > 0) {
                            ++contentBounds.width;
                            xTextOffset += contentBounds.width;
                        }
                    } else {
                        contentBounds = new Rectangle(0, 0, 0, 0);
                    }
                    contentBounds.width += textExtent.x;
                    contentBounds.height += textExtent.y;
                    if (align == 131072) {
                        int dx = Math.max(6, itemBounds.x + itemBounds.width - xImageOffset - contentBounds.width - 6);
                        xTextOffset += dx;
                    } else if (align == 0x1000000) {
                        int dx = Math.max(6, (itemBounds.x + itemBounds.width - xImageOffset - contentBounds.width - 6) / 2);
                        xTextOffset += dx;
                    }
                    if (pImg != null) {
                        event.gc.drawImage(pImg, xImageOffset, yOffset);
                    }
                    event.gc.drawText(ptext, xTextOffset, yOffset, true);
                    event.gc.setForeground(event.gc.getDevice().getSystemColor(19));
                    break;
                }
                case 40: {
                    event.detail &= 0xFFFFFFFB;
                    event.detail &= 0xFFFFFFEF;
                }
            }
        }
    }
}

