/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.util;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.basic.comp.CLabelEx;
import org.eclipse.scout.rt.ui.swt.basic.comp.HyperlinkEx;
import org.eclipse.scout.rt.ui.swt.ext.ButtonEx;
import org.eclipse.scout.rt.ui.swt.ext.ImageViewer;
import org.eclipse.scout.rt.ui.swt.ext.ScrolledFormEx;
import org.eclipse.scout.rt.ui.swt.ext.SectionContent;
import org.eclipse.scout.rt.ui.swt.ext.SnapButtonMaximized;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelTop;
import org.eclipse.scout.rt.ui.swt.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.swt.ext.TextEx;
import org.eclipse.scout.rt.ui.swt.ext.table.TableEx;
import org.eclipse.scout.rt.ui.swt.ext.tree.TreeEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.util.WrappedFormToolkit;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ScoutFormToolkit
extends WrappedFormToolkit {
    public ScoutFormToolkit(FormToolkit kit) {
        super(kit);
    }

    public ScrolledFormEx createScrolledFormEx(Composite parent, int style) {
        ScrolledFormEx form = new ScrolledFormEx(parent, style);
        this.adapt((Control)form, false, false);
        if (form.getBody() != null) {
            this.adapt((Control)form.getBody(), false, false);
        }
        form.setBackground(this.kit.getColors().getBackground());
        form.setForeground(this.kit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return form;
    }

    @Override
    public ScrolledForm createScrolledForm(Composite parent) {
        ScrolledForm form = new ScrolledForm(parent, 0x240 | this.kit.getOrientation());
        this.adapt((Control)form, false, false);
        form.setBackground(this.kit.getColors().getBackground());
        form.setForeground(this.kit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        form.setFont(JFaceResources.getHeaderFont());
        return form;
    }

    @Override
    public TreeEx createTree(Composite parent, int style) {
        TreeEx tree = new TreeEx(parent, style);
        this.adapt((Control)tree, false, false);
        return tree;
    }

    @Override
    public TableEx createTable(Composite parent, int style) {
        return this.createTable(parent, style, false);
    }

    public TableEx createTable(Composite parent, int style, boolean multilineText) {
        TableEx table = new TableEx(parent, style, multilineText);
        this.adapt((Control)table, false, false);
        return table;
    }

    public int computeSwtLabelHorizontalAlignment(int scoutAlign) {
        switch (scoutAlign) {
            case -1: {
                return 16384;
            }
            case 0: {
                return 0x1000000;
            }
            case 1: {
                return 131072;
            }
        }
        return UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
    }

    protected int computeSwtLabelStyle(IFormField scoutObject) {
        if (scoutObject == null) {
            return 0;
        }
        return this.computeSwtLabelHorizontalAlignment(scoutObject.getLabelHorizontalAlignment());
    }

    public StatusLabelEx createStatusLabel(Composite parent, ISwtEnvironment environment, IFormField scoutObject) {
        int labelStyle = this.computeSwtLabelStyle(scoutObject);
        return this.createStatusLabel(parent, environment, scoutObject, labelStyle);
    }

    public StatusLabelEx createStatusLabel(Composite parent, ISwtEnvironment environment, IFormField scoutObject, int style) {
        StatusLabelEx label = null;
        label = scoutObject != null && scoutObject.getLabelPosition() == 4 ? new StatusLabelTop(parent, style, environment) : new StatusLabelEx(parent, style, environment);
        this.adapt((Control)label, false, false);
        return label;
    }

    public StyledText createStyledText(Composite parent, int style) {
        StyledTextEx text = new StyledTextEx(parent, style);
        this.adapt((Control)text, false, false);
        text.setIndent(2);
        return text;
    }

    public CTabFolder createTabFolder(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 128);
        this.adapt((Control)folder, false, false);
        return folder;
    }

    public Text createText(Composite container, int style) {
        TextEx t = new TextEx(container, style);
        this.adapt((Control)t, false, false);
        return t;
    }

    public SectionContent createSectionClient(Composite parent) {
        SectionContent client = new SectionContent(parent, 0);
        this.adapt((Control)client, false, false);
        return client;
    }

    public ButtonEx createButtonEx(Composite parent, int style) {
        ButtonEx button = new ButtonEx(parent, style | 0x800000);
        this.adapt((Control)button, false, false);
        return button;
    }

    public Canvas createCanvas(Composite container) {
        Canvas c = new Canvas(container, 0);
        this.adapt((Control)c, false, false);
        return c;
    }

    public Browser createBrowser(Composite container, int style) {
        Browser browser = new Browser(container, style);
        this.adapt((Control)browser, false, false);
        return browser;
    }

    public SnapButtonMaximized createSnapButtonMaximized(Composite parent) {
        SnapButtonMaximized button = new SnapButtonMaximized(parent, 0);
        this.adapt((Composite)button);
        return button;
    }

    public SashForm createSashForm(Composite parent, int style) {
        SashForm button = new SashForm(parent, style);
        this.adapt((Composite)button);
        return button;
    }

    public CLabelEx createCLabel(Composite parent, String text) {
        return this.createCLabel(parent, text, 0);
    }

    public CLabelEx createCLabel(Composite parent, String text, int style) {
        CLabelEx label = new CLabelEx(parent, style | this.getOrientation());
        if (text != null) {
            label.setText(text);
        }
        this.adapt((Control)label, false, false);
        return label;
    }

    public ImageViewer createImageViewer(Composite container) {
        ImageViewer viewer = new ImageViewer(container);
        this.adapt((Control)viewer, false, false);
        return viewer;
    }

    @Override
    public HyperlinkEx createHyperlink(Composite parent, String text, int style) {
        HyperlinkEx hyperlink = new HyperlinkEx(parent, style | this.getOrientation());
        if (text != null) {
            hyperlink.setText(text);
        }
        this.getHyperlinkGroup().add((Hyperlink)hyperlink);
        this.adapt((Composite)hyperlink);
        hyperlink.addListener(1, new P_HyperlinkKeyListener());
        return hyperlink;
    }

    private class P_HyperlinkKeyListener
    implements Listener {
        private P_HyperlinkKeyListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 1) {
                switch (event.keyCode) {
                    case 9: {
                        int traversal = 16;
                        if ((event.stateMask & 0x20000) != 0) {
                            traversal = 8;
                        }
                        ((Control)event.widget).traverse(traversal);
                    }
                }
            }
        }
    }
}

