/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.compatibility.v35.internal;

import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.ILicense;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.InstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileModificationOperation;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.scout.sdk.compatibility.License;
import org.eclipse.scout.sdk.compatibility.internal.service.IP2CompatService;

public class P2CompatService
implements IP2CompatService {
    public String getLatestVersion(String rootIU, URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        String[] latestVersions = this.getLatestVersions(new String[]{rootIU}, p2RepositoryURI, monitor);
        if (latestVersions != null && latestVersions.length > 0) {
            return latestVersions[0];
        }
        return null;
    }

    public Map<String, License[]> getLicense(String rootIU, URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        IInstallableUnit[] units = this.getInstallableUnits(new String[]{rootIU}, this.getMetadataRepository(p2RepositoryURI, monitor), monitor);
        HashMap<String, License[]> ret = new HashMap<String, License[]>(units.length);
        IInstallableUnit[] iInstallableUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            ILicense license = iu.getLicense();
            if (license.getBody() != null && license.getBody().trim().length() > 0) {
                ret.put(iu.getId(), new License[]{new License(license.getBody(), iu.getId())});
            }
            ++n2;
        }
        return ret;
    }

    public void installUnit(String rootIU, URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        ProfileChangeRequest request;
        IInstallableUnit[] units = this.getInstallableUnits(new String[]{rootIU}, this.getMetadataRepository(p2RepositoryURI, monitor), monitor);
        String profileId = ProvSDKUIActivator.getSelfProfileId();
        PlannerResolutionOperation resolutionOp = new PlannerResolutionOperation(ProvUIMessages.ProfileModificationWizardPage_ResolutionOperationLabel, profileId, request = InstallAction.computeProfileChangeRequest((IInstallableUnit[])units, (String)profileId, (MultiStatus)PlanAnalyzer.getProfileChangeAlteredStatus(), (IProgressMonitor)monitor), new ProvisioningContext(), PlanAnalyzer.getProfileChangeAlteredStatus(), false);
        IStatus resolutionResult = resolutionOp.execute(monitor);
        if (!resolutionResult.isOK()) {
            throw new CoreException(resolutionResult);
        }
        ProvisioningContext context = resolutionOp.getProvisioningContext();
        context.setArtifactRepositories(new URI[]{p2RepositoryURI});
        ProfileModificationOperation modificationOp = new ProfileModificationOperation(ProvUIMessages.InstallIUOperationLabel, profileId, resolutionOp.getProvisioningPlan(), context);
        IStatus modificationResult = modificationOp.execute(monitor);
        if (!modificationResult.isOK()) {
            throw new CoreException(modificationResult);
        }
    }

    public void promptForRestart() {
        ProvisioningOperationRunner.suppressRestart((boolean)true);
        ProvisioningOperationRunner.requestRestart((boolean)true);
        ProvisioningOperationRunner.suppressRestart((boolean)false);
        ProvisioningOperationRunner.requestRestart((boolean)true);
    }

    private IInstallableUnit[] getInstallableUnits(String[] rootIUs, IMetadataRepository metadataRepository, IProgressMonitor monitor) throws CoreException {
        IInstallableUnit[] result = new IInstallableUnit[rootIUs.length];
        int i = 0;
        while (i < rootIUs.length) {
            IInstallableUnit iu;
            String rootIuId = rootIUs[i];
            Collector queryResult = new Collector();
            CompositeQuery latestIUQuery = new CompositeQuery(new Query[]{new InstallableUnitQuery(rootIuId), new LatestIUVersionQuery()});
            metadataRepository.query((Query)latestIUQuery, queryResult, monitor);
            if (queryResult.isEmpty()) {
                String messag = "Feature <{0}> not found";
                Object[] arguments = new Object[]{rootIuId};
                String fmtMessage = MessageFormat.format(messag, arguments);
                Status status = new Status(4, "org.eclipse.scout.sdk.compatibility", fmtMessage);
                throw new CoreException((IStatus)status);
            }
            Iterator iterator = queryResult.iterator();
            result[i] = iu = (IInstallableUnit)iterator.next();
            ++i;
        }
        return result;
    }

    private IMetadataRepository getMetadataRepository(URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)PDECore.getDefault().acquireService(IMetadataRepositoryManager.class.getName());
        return manager.loadRepository(p2RepositoryURI, monitor);
    }

    private String[] getLatestVersions(String[] rootIUs, URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        String[] result = this.getLatestVersions(rootIUs, this.getMetadataRepository(p2RepositoryURI, monitor), monitor);
        return result;
    }

    private String[] getLatestVersions(String[] rootIUs, IMetadataRepository metadataRepository, IProgressMonitor monitor) throws CoreException {
        IInstallableUnit[] units = this.getInstallableUnits(rootIUs, metadataRepository, monitor);
        String[] result = new String[units.length];
        int i = 0;
        while (i < result.length) {
            result[i] = units[i].getVersion().toString();
            ++i;
        }
        return result;
    }
}

