/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.rap.ui.internal.extensions.technology;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.sdk.compatibility.P2Utility;
import org.eclipse.scout.sdk.compatibility.TargetPlatformUtility;
import org.eclipse.scout.sdk.rap.ScoutSdkRap;
import org.eclipse.scout.sdk.ui.extensions.technology.AbstractScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.extensions.technology.ScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.dialog.LicenseDialog;
import org.eclipse.scout.sdk.util.ResourcesUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.osgi.framework.Version;

public class FileChooserRapTargetTechnologyHandler
extends AbstractScoutTechnologyHandler {
    private static final String RAP_INCUBATOR_UPDATE_SITE_URL = "http://download.eclipse.org/rt/rap/1.5/incubator";
    private static final String RAP_INCUBATOR_FEATURE_NAME = "org.eclipse.rap.incubator.supplemental.fileupload.feature.feature.group";
    private static final Version RAP_INCUBATOR_FEATURE_VERSION = new Version(1, 5, 0, "20120220-1720");
    private static final String SCOUT_INCUBATOR_FEATURE_NAME = "org.eclipse.scout.rt.ui.rap.incubator.filechooser.feature.feature.group";
    private static final String SCOUT_INCUBATOR_UPDATE_SITE_URL = "http://download.eclipse.org/scout/releases/3.8";

    public boolean preSelectionChanged(boolean selected, IProgressMonitor monitor) throws CoreException {
        if (!selected) {
            return true;
        }
        try {
            final BooleanHolder licAccepted = new BooleanHolder(Boolean.valueOf(false));
            final Map lic = P2Utility.getLicense((String)RAP_INCUBATOR_FEATURE_NAME, (URI)new URI(RAP_INCUBATOR_UPDATE_SITE_URL), (IProgressMonitor)monitor);
            Map licScout = P2Utility.getLicense((String)SCOUT_INCUBATOR_FEATURE_NAME, (URI)new URI(SCOUT_INCUBATOR_UPDATE_SITE_URL), (IProgressMonitor)monitor);
            lic.putAll(licScout);
            ScoutSdkUi.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    LicenseDialog licDialog = new LicenseDialog(ScoutSdkUi.getShell(), lic);
                    if (licDialog.open() == 0) {
                        licAccepted.setValue((Object)true);
                    }
                }
            });
            return (Boolean)licAccepted.getValue();
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
    }

    public void selectionChanged(IScoutTechnologyResource[] resources, boolean selected, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        String scoutIncubVersion = "0.0.0";
        if (selected) {
            try {
                scoutIncubVersion = P2Utility.getLatestVersion((String)SCOUT_INCUBATOR_FEATURE_NAME, (URI)new URI(SCOUT_INCUBATOR_UPDATE_SITE_URL), (IProgressMonitor)monitor);
            }
            catch (URISyntaxException e) {
                ScoutSdkRap.logError((Throwable)e);
            }
        }
        IScoutTechnologyResource[] iScoutTechnologyResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutTechnologyResource r = iScoutTechnologyResourceArray[n2];
            if (selected) {
                TargetPlatformUtility.addInstallableUnitsToTarget((IFile)r.getResource(), (String[])new String[]{RAP_INCUBATOR_FEATURE_NAME, SCOUT_INCUBATOR_FEATURE_NAME}, (String[])new String[]{RAP_INCUBATOR_FEATURE_VERSION.toString(), scoutIncubVersion}, (String[])new String[]{RAP_INCUBATOR_UPDATE_SITE_URL, SCOUT_INCUBATOR_UPDATE_SITE_URL});
            } else {
                TargetPlatformUtility.removeInstallableUnitsFromTarget((IFile)r.getResource(), (String[])new String[]{RAP_INCUBATOR_FEATURE_NAME, SCOUT_INCUBATOR_FEATURE_NAME});
            }
            ++n2;
        }
        if (resources.length == 1) {
            TargetPlatformUtility.resolveTargetPlatform((IFile)resources[0].getResource(), (boolean)true, (IProgressMonitor)monitor);
        }
    }

    public TriState getSelection(IScoutProject project) {
        ScoutTechnologyResource[] targetFiles = FileChooserRapTargetTechnologyHandler.getTargetFiles(project);
        if (targetFiles.length < 1) {
            return TriState.FALSE;
        }
        TriState ret = TriState.parseTriState((Object)this.containsIncubator(targetFiles[0].getResource()));
        int i = 1;
        while (i < targetFiles.length) {
            TriState tmp = TriState.parseTriState((Object)this.containsIncubator(targetFiles[i].getResource()));
            if (ret != tmp) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    private boolean containsIncubator(IFile targetFile) {
        try {
            String content = ResourcesUtility.getContent((IFile)targetFile);
            return content.contains(SCOUT_INCUBATOR_FEATURE_NAME) && content.contains(RAP_INCUBATOR_FEATURE_NAME);
        }
        catch (CoreException e) {
            ScoutSdkRap.logError((Throwable)e);
            return false;
        }
    }

    public boolean isActive(IScoutProject project) {
        IScoutBundle[] rapBundles = project.getAllBundles(8);
        return project.getClientBundle() != null && rapBundles != null && rapBundles.length > 0 && FileChooserRapTargetTechnologyHandler.getTargetFiles(project).length > 0;
    }

    private static ScoutTechnologyResource[] getTargetFiles(IScoutProject project) {
        final ArrayList ret = new ArrayList();
        try {
            IScoutBundle[] iScoutBundleArray = project.getAllScoutBundles();
            int n = iScoutBundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScoutBundle b;
                final IScoutBundle bundle = b = iScoutBundleArray[n2];
                bundle.getProject().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        IFile f;
                        String fileName;
                        if (resource != null && resource.getType() == 1 && resource.exists() && (fileName = (f = (IFile)resource).getName()).toLowerCase().endsWith(".target")) {
                            boolean checked = fileName.equals("ScoutRAP.target");
                            ret.add(new ScoutTechnologyResource(bundle, f, checked));
                        }
                        return true;
                    }
                }, 2, false);
                ++n2;
            }
        }
        catch (CoreException e) {
            ScoutSdkRap.logError((Throwable)e);
        }
        return ret.toArray(new ScoutTechnologyResource[ret.size()]);
    }

    protected void contributeResources(IScoutProject project, List<IScoutTechnologyResource> list) {
        ScoutTechnologyResource[] scoutTechnologyResourceArray = FileChooserRapTargetTechnologyHandler.getTargetFiles(project);
        int n = scoutTechnologyResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutTechnologyResource r = scoutTechnologyResourceArray[n2];
            list.add((IScoutTechnologyResource)r);
            ++n2;
        }
    }
}

