/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.dialog.AbstractStatusDialog;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TemplateFromFromFieldDialog
extends AbstractStatusDialog {
    private StyledTextField m_templateNameField;
    private Button m_replaceExistingFormField;
    private Button m_createExternalFormDataField;
    private final IType m_formField;
    private String m_templateName;
    private boolean m_replaceFormField;
    private boolean m_createExternalFormData;

    public TemplateFromFromFieldDialog(Shell parentShell, String templateName, IType formField) {
        super(parentShell);
        this.m_formField = formField;
        this.m_templateName = templateName;
        this.m_replaceFormField = true;
        this.m_createExternalFormData = true;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(Texts.get((String)"CreateTemplateOf", (String[])new String[]{this.getFormField().getElementName()}));
        this.setMessage(Texts.get((String)"TemplateDesc"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Texts.get((String)"TemplateSupport"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.m_templateNameField = this.getFieldToolkit().createStyledTextField(container, Texts.get((String)"TemplateName"));
        this.m_templateNameField.setReadOnlyPrefix("Abstract");
        this.m_templateNameField.setText(this.getTemplateName());
        this.m_templateNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateFromFromFieldDialog.this.m_templateName = TemplateFromFromFieldDialog.this.m_templateNameField.getText();
                TemplateFromFromFieldDialog.this.pingStateChanging();
            }
        });
        this.m_replaceExistingFormField = new Button(container, 32);
        this.m_replaceExistingFormField.setText(Texts.get((String)"UseTemplateFor", (String[])new String[]{this.getFormField().getElementName()}));
        this.m_replaceExistingFormField.setSelection(this.isReplaceFormField());
        this.m_replaceExistingFormField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateFromFromFieldDialog.this.m_replaceFormField = TemplateFromFromFieldDialog.this.m_replaceExistingFormField.getSelection();
                TemplateFromFromFieldDialog.this.pingStateChanging();
            }
        });
        this.m_createExternalFormDataField = new Button(container, 32);
        this.m_createExternalFormDataField.setText(Texts.get((String)"CreateExternalFormData"));
        this.m_createExternalFormDataField.setSelection(this.isCreateExternalFormData());
        this.m_createExternalFormDataField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateFromFromFieldDialog.this.m_createExternalFormData = TemplateFromFromFieldDialog.this.m_createExternalFormDataField.getSelection();
                TemplateFromFromFieldDialog.this.pingStateChanging();
            }
        });
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(1, true));
        this.m_templateNameField.setLayoutData(new GridData(768));
        this.m_replaceExistingFormField.setLayoutData((Object)new GridData(768));
        this.m_createExternalFormDataField.setLayoutData((Object)new GridData(768));
        return container;
    }

    @Override
    protected void validate(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusTemplateName());
    }

    private IStatus getStatusTemplateName() {
        if (StringUtility.isNullOrEmpty((String)this.getTemplateName()) || "Abstrat".equals(this.getTemplateName())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NameNotValid"));
        }
        IScoutBundle bundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.getFormField());
        if (TypeUtility.existsType((String)(String.valueOf(bundle.getPackageName(".ui.template.formfield")) + "." + this.getTemplateName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TemplateAlreadyExists"));
        }
        return Status.OK_STATUS;
    }

    public IType getFormField() {
        return this.m_formField;
    }

    public String getTemplateName() {
        return this.m_templateName;
    }

    public boolean isReplaceFormField() {
        return this.m_replaceFormField;
    }

    public boolean isCreateExternalFormData() {
        return this.m_createExternalFormData;
    }
}

