/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextSelectionHandler;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeComparators;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Composite;

public class FieldToolkit {
    public StyledTextField createStyledTextField(Composite parent, String label) {
        StyledTextField field = new StyledTextField(parent, label);
        return field;
    }

    public ProposalTextField createProposalField(Composite parent, String label) {
        return this.createProposalField(parent, label, ProposalTextField.STYLE_DEFAULT);
    }

    public ProposalTextField createProposalField(Composite parent, String label, int style) {
        if (label == null) {
            label = "";
        }
        ProposalTextField field = new ProposalTextField(parent, style);
        field.setLabelText(label);
        return field;
    }

    public ProposalTextField createNlsProposalTextField(Composite parent, INlsProject nlsProject, String label) {
        return this.createNlsProposalTextField(parent, nlsProject, label, ProposalTextField.STYLE_DEFAULT);
    }

    public ProposalTextField createNlsProposalTextField(Composite parent, INlsProject nlsProject, String label, int style) {
        if (nlsProject == null) {
            throw new IllegalArgumentException("nlsProject can not be null!");
        }
        ProposalTextField field = this.createProposalField(parent, label, style);
        NlsTextLabelProvider labelProvider = new NlsTextLabelProvider(nlsProject);
        field.setLabelProvider((IBaseLabelProvider)labelProvider);
        field.setContentProvider(new NlsTextContentProvider(labelProvider));
        field.setSelectionHandler(new NlsTextSelectionHandler(nlsProject));
        field.setProposalDescriptionProvider(new NlsProposalDescriptionProvider());
        return field;
    }

    public ProposalTextField createSignatureProposalField(Composite parent, String label, IScoutBundle bundle) {
        return this.createSignatureProposalField(parent, label, bundle, null);
    }

    public ProposalTextField createSignatureProposalField(Composite parent, String label, IScoutBundle bundle, String[] mostlyUsed) {
        ProposalTextField field = this.createProposalField(parent, label);
        SignatureLabelProvider labelProvider = new SignatureLabelProvider();
        field.setLabelProvider((IBaseLabelProvider)labelProvider);
        SignatureProposalProvider proposalProvider = new SignatureProposalProvider(bundle.getSearchScope(), labelProvider, mostlyUsed, false);
        field.setContentProvider(proposalProvider);
        return field;
    }

    public ProposalTextField createSiblingProposalField(Composite parent, IType declaringType, IType siblingDeclaringType) {
        ITypeHierarchy localHierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{declaringType});
        return this.createSiblingProposalField(parent, declaringType, siblingDeclaringType, localHierarchy);
    }

    public ProposalTextField createSiblingProposalField(Composite parent, IType declaringType, IType siblingDeclaringType, ITypeHierarchy hierarchy) {
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassFilter(), TypeFilters.getSubtypeFilter((IType)siblingDeclaringType, (ITypeHierarchy)hierarchy)});
        IType[] innerTypes = TypeUtility.getInnerTypes((IType)declaringType, (ITypeFilter)filter, (Comparator)ScoutTypeComparators.getOrderAnnotationComparator());
        ArrayList<SiblingProposal> siblingList = new ArrayList<SiblingProposal>();
        IType[] iTypeArray = innerTypes;
        int n = innerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            siblingList.add(new SiblingProposal((IJavaElement)t));
            ++n2;
        }
        siblingList.add(SiblingProposal.SIBLING_END);
        ProposalTextField field = this.createProposalField(parent, Texts.get((String)"Sibling"));
        field.setEnabled(siblingList.size() > 1);
        field.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider());
        field.setContentProvider(new SimpleProposalProvider(siblingList.toArray(new SiblingProposal[siblingList.size()])));
        return field;
    }

    public ProposalTextField createFormFieldSiblingProposalField(Composite parent, IType declaringType) {
        ITypeHierarchy localHierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{declaringType});
        ProposalTextField field = this.createSiblingProposalField(parent, declaringType, TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField"), localHierarchy);
        SiblingProposal selectedProposal = SiblingProposal.SIBLING_END;
        IType firstButton = ScoutTypeUtility.getFistProcessButton((IType)declaringType, (ITypeHierarchy)localHierarchy);
        if (firstButton != null) {
            selectedProposal = new SiblingProposal((IJavaElement)firstButton);
        }
        field.acceptProposal(selectedProposal);
        return field;
    }

    public ProposalTextField createJavaElementProposalField(Composite parent, String label, AbstractJavaElementContentProvider contentProvider) {
        ProposalTextField field = this.createProposalField(parent, label);
        field.setLabelProvider((IBaseLabelProvider)contentProvider.getLabelProvider());
        field.setContentProvider(contentProvider);
        return field;
    }
}

