/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.nls;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IDialogSettingsProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;

public class NlsTextContentProvider
extends ContentProposalProvider
implements IDialogSettingsProvider {
    public static final Object NLS_NEW_PROPOSAL = new Object();
    private NlsTextLabelProvider m_labelProvider;

    public NlsTextContentProvider(NlsTextLabelProvider labelProvider) {
        this.m_labelProvider = labelProvider;
    }

    @Override
    public Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
        HashSet<INlsEntry> entries = new HashSet<INlsEntry>();
        if (this.getLabelProvider().getNlsProject() != null) {
            if (!StringUtility.hasText((String)searchPattern)) {
                searchPattern = "*";
            }
            this.getLabelProvider().startRecordMatchRegions();
            ContentProposalProvider.NormalizedPattern pattern = NlsTextContentProvider.createNormalizedSearchPattern(searchPattern);
            Language developmentLanguage = this.getLabelProvider().getNlsProject().getDevelopmentLanguage();
            INlsEntry[] iNlsEntryArray = this.getLabelProvider().getNlsProject().getAllEntries();
            int n = iNlsEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                INlsEntry entry = iNlsEntryArray[n2];
                if (monitor.isCanceled()) break;
                int[] matchingRegions = this.getMatchingRegions(entry, entry.getTranslation(developmentLanguage), pattern);
                if (matchingRegions != null) {
                    entries.add(entry);
                    this.getLabelProvider().addMatchRegions(entry, matchingRegions);
                } else {
                    if (this.getMatchingRegions(entry, entry.getKey(), pattern) != null) {
                        entries.add(entry);
                    }
                    for (Map.Entry e : entry.getAllTranslations().entrySet()) {
                        if (developmentLanguage.equals(e.getKey()) || this.getMatchingRegions(entry, (String)e.getValue(), pattern) == null) continue;
                        entries.add(entry);
                        break;
                    }
                }
                ++n2;
            }
            INlsEntry[] nlsEntryResult = entries.toArray(new INlsEntry[entries.size()]);
            Arrays.sort(nlsEntryResult, new P_NlsEntryComparator());
            Object[] result = new Object[nlsEntryResult.length + 1];
            System.arraycopy(nlsEntryResult, 0, result, 0, nlsEntryResult.length);
            result[result.length - 1] = NLS_NEW_PROPOSAL;
            return result;
        }
        return new Object[0];
    }

    public NlsTextLabelProvider getLabelProvider() {
        return this.m_labelProvider;
    }

    @Override
    public IDialogSettings getDialogSettings() {
        return ScoutSdkUi.getDefault().getDialogSettingsSection(NlsTextLabelProvider.class.getName(), true);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NlsTextContentProvider)) {
            return false;
        }
        NlsTextContentProvider ref = (NlsTextContentProvider)obj;
        return CompareUtility.equals((Object)this.getLabelProvider(), (Object)ref.getLabelProvider());
    }

    private class P_NlsEntryComparator
    implements Comparator<INlsEntry> {
        private P_NlsEntryComparator() {
        }

        @Override
        public int compare(INlsEntry o1, INlsEntry o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Language developmentLanguage = o1.getProject().getDevelopmentLanguage();
            return CompareUtility.compareTo((Comparable)new CompositeObject(new Object[]{o1.getTranslation(developmentLanguage), o1.getKey()}), (Comparable)new CompositeObject(new Object[]{o2.getTranslation(developmentLanguage), o2.getKey()}));
        }
    }
}

