/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.extensions.IContextMenuContributor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;

public class ContextMenuContributorExtensionPoint {
    private static final Object contextMenuExtensionsCacheLock = new Object();
    private static IScoutHandler[] contextMenuExtensions;
    private static final Object contextMenuContributorExtensionsCacheLock;
    private static MenuContributionInfo[] contextMenuContributorExtensions;
    private static Map<IScoutHandler.Category, ArrayList<IScoutHandler>> contextMenuByCat;

    static {
        contextMenuContributorExtensionsCacheLock = new Object();
    }

    public static IContextMenuContributor[] getContextMenuContributors(IPage page) {
        ArrayList<IContextMenuContributor> ret = new ArrayList<IContextMenuContributor>();
        MenuContributionInfo[] menuContributionInfoArray = ContextMenuContributorExtensionPoint.getContributors();
        int n = menuContributionInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuContributionInfo i = menuContributionInfoArray[n2];
            if (page == null || i.pageClassFilter == null || i.pageClassFilter.isAssignableFrom(page.getClass())) {
                ret.add(i.contributor);
            }
            ++n2;
        }
        return ret.toArray(new IContextMenuContributor[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MenuContributionInfo[] getContributors() {
        if (contextMenuContributorExtensions == null) {
            Object object = contextMenuContributorExtensionsCacheLock;
            synchronized (object) {
                if (contextMenuContributorExtensions == null) {
                    final ArrayList list = new ArrayList();
                    ContextMenuContributorExtensionPoint.visitExtensions("contextMenuContributor", "contributor", new IExtensionVisitor(){

                        @Override
                        public boolean visit(IConfigurationElement element) {
                            try {
                                String pageClassName = element.getAttribute("page");
                                IContextMenuContributor ext = (IContextMenuContributor)element.createExecutableExtension("class");
                                Class<?> clazz = null;
                                if (pageClassName != null) {
                                    clazz = Class.forName(pageClassName.trim());
                                }
                                MenuContributionInfo info = new MenuContributionInfo(ext, clazz);
                                list.add(info);
                            }
                            catch (Throwable t) {
                                ScoutSdkUi.logError("create context menu contributor: " + element.getAttribute("class"), t);
                            }
                            return true;
                        }
                    });
                    contextMenuContributorExtensions = list.toArray(new MenuContributionInfo[list.size()]);
                }
            }
        }
        return contextMenuContributorExtensions;
    }

    public static void visitExtensions(String extensionPointName, String elementName, IExtensionVisitor v) {
        IExtension[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", extensionPointName);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (elementName.equals(element.getName()) && !v.visit(element)) {
                    return;
                }
                ++n4;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IScoutHandler[] getAllRegisteredContextMenus() {
        if (contextMenuExtensions == null) {
            Object object = contextMenuExtensionsCacheLock;
            synchronized (object) {
                if (contextMenuExtensions == null) {
                    final ArrayList list = new ArrayList();
                    ContextMenuContributorExtensionPoint.visitExtensions("contextMenu", "contextMenu", new IExtensionVisitor(){

                        @Override
                        public boolean visit(IConfigurationElement element) {
                            try {
                                IScoutHandler ext = (IScoutHandler)element.createExecutableExtension("class");
                                list.add(ext);
                            }
                            catch (Throwable t) {
                                ScoutSdkUi.logError("create context menu: " + element.getAttribute("class"), t);
                            }
                            return true;
                        }
                    });
                    contextMenuExtensions = list.toArray(new IScoutHandler[list.size()]);
                }
            }
        }
        return contextMenuExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<IScoutHandler.Category, ArrayList<IScoutHandler>> getAllRegisteredContextMenusByCategory() {
        if (contextMenuByCat == null) {
            Object object = contextMenuExtensionsCacheLock;
            synchronized (object) {
                if (contextMenuByCat == null) {
                    TreeMap<IScoutHandler.Category, ArrayList<IScoutHandler>> sorted = new TreeMap<IScoutHandler.Category, ArrayList<IScoutHandler>>(new Comparator<IScoutHandler.Category>(){

                        @Override
                        public int compare(IScoutHandler.Category o1, IScoutHandler.Category o2) {
                            return new Integer(o1.getOrder()).compareTo(o2.getOrder());
                        }
                    });
                    IScoutHandler[] iScoutHandlerArray = ContextMenuContributorExtensionPoint.getAllRegisteredContextMenus();
                    int n = iScoutHandlerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IScoutHandler a = iScoutHandlerArray[n2];
                        ArrayList<IScoutHandler> listOfCurCat = sorted.get((Object)a.getCategory());
                        if (listOfCurCat == null) {
                            listOfCurCat = new ArrayList();
                            sorted.put(a.getCategory(), listOfCurCat);
                        }
                        listOfCurCat.add(a);
                        ++n2;
                    }
                    contextMenuByCat = sorted;
                }
            }
        }
        return contextMenuByCat;
    }

    static interface IExtensionVisitor {
        public boolean visit(IConfigurationElement var1);
    }

    private static class MenuContributionInfo {
        private IContextMenuContributor contributor;
        private Class<? extends IPage> pageClassFilter;

        public MenuContributionInfo(IContextMenuContributor c, Class<? extends IPage> p) {
            this.contributor = c;
            this.pageClassFilter = p;
        }
    }
}

