/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.bundle;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.ui.extensions.bundle.IScoutBundleProvider;
import org.eclipse.scout.sdk.ui.extensions.project.IScoutBundleExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtension;

public class ScoutBundleExtensionPoint {
    private static String extensionId = "scoutBundle";
    private static String attributeBundleId = "id";
    private static String attributeBundleName = "bundleName";
    private static String attributeBundleType = "bundleType";
    private static String attributeOrderNumber = "orderNumber";
    private static String attributeClass = "class";
    private static String attributeIcon = "icon";
    private static final ScoutBundleExtensionPoint instance = new ScoutBundleExtensionPoint();
    private TreeSet<ScoutBundleExtension> m_extensions = new TreeSet<ScoutBundleExtension>(new P_ExtensionComparator());

    private ScoutBundleExtensionPoint() {
        this.init();
    }

    private void init() {
        IExtension[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", extensionId);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                ScoutBundleExtension extensionPoint = new ScoutBundleExtension();
                extensionPoint.setBundleID(element.getAttribute(attributeBundleId));
                extensionPoint.setBundleName(element.getAttribute(attributeBundleName));
                try {
                    extensionPoint.setBundleExtension((IScoutBundleProvider)element.createExecutableExtension(attributeClass));
                }
                catch (CoreException e) {
                    ScoutSdkUi.logError("could not load class '" + element.getAttribute(attributeClass) + "'.", e);
                }
                extensionPoint.setIconPath(element.getAttribute(attributeIcon));
                String attOrderNr = element.getAttribute(attributeOrderNumber);
                try {
                    extensionPoint.setOrderNumber(new Integer(attOrderNr));
                }
                catch (NumberFormatException e) {
                    ScoutSdkUi.logError("could not parse order number '" + attOrderNr + "' of extension '" + element.getNamespaceIdentifier() + "'.", e);
                }
                String bundleTypeString = element.getAttribute(attributeBundleType);
                IScoutBundleExtension.BundleTypes bundleType = IScoutBundleExtension.BundleTypes.valueOf(bundleTypeString);
                extensionPoint.setBundleType(bundleType);
                if (extensionPoint.isValidConfiguration()) {
                    this.m_extensions.add(extensionPoint);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static final ScoutBundleExtension[] getExtensions() {
        return instance.getExtensionsImpl();
    }

    private final ScoutBundleExtension[] getExtensionsImpl() {
        return this.m_extensions.toArray(new ScoutBundleExtension[this.m_extensions.size()]);
    }

    private class P_ExtensionComparator
    implements Comparator<ScoutBundleExtension> {
        private P_ExtensionComparator() {
        }

        @Override
        public int compare(ScoutBundleExtension o1, ScoutBundleExtension o2) {
            if (o1.getOrderNumber() != o2.getOrderNumber()) {
                return o2.getOrderNumber() - o1.getOrderNumber();
            }
            return o1.getBundleName().compareTo(o2.getBundleName());
        }
    }
}

