/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.job;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.jobs.AbstractWorkspaceBlockingJob;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LoadInitialOutlineProcess
extends AbstractWorkspaceBlockingJob {
    private ScoutExplorerPart m_view;

    public LoadInitialOutlineProcess(ScoutExplorerPart view) {
        super("Loading outline");
        this.m_view = view;
    }

    public String getProcessName() {
        return "Loading outline";
    }

    protected void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        Control c = this.m_view.getTreeViewer().getControl();
        if (c.isDisposed()) {
            return;
        }
        Display display = c.getDisplay();
        IPage rootPage = (IPage)this.m_view.getTreeViewer().getInput();
        final Cursor waitCursor = new Cursor((Device)display, 1);
        try {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    LoadInitialOutlineProcess.this.m_view.getTreeViewer().getControl().setCursor(waitCursor);
                    LoadInitialOutlineProcess.this.m_view.getViewContentProvider().setAutoLoadChildren(false);
                }
            });
            this.loadNodeRec(rootPage, monitor);
        }
        catch (Throwable throwable) {
            display.asyncExec(new Runnable(rootPage, waitCursor){
                private final /* synthetic */ IPage val$rootPage;
                private final /* synthetic */ Cursor val$waitCursor;
                {
                    this.val$rootPage = iPage;
                    this.val$waitCursor = cursor;
                }

                @Override
                public void run() {
                    LoadInitialOutlineProcess.this.m_view.getTreeViewer().refresh();
                    LoadInitialOutlineProcess.this.expandLoadedNodeRec(this.val$rootPage);
                    LoadInitialOutlineProcess.this.m_view.getViewContentProvider().setAutoLoadChildren(true);
                    LoadInitialOutlineProcess.this.m_view.getTreeViewer().getControl().setCursor(null);
                    this.val$waitCursor.dispose();
                }
            });
            throw throwable;
        }
        display.asyncExec(new /* invalid duplicate definition of identical inner class */);
    }

    private void loadNodeRec(IPage page, IProgressMonitor monitor) {
        if (page.isInitiallyLoaded()) {
            monitor.subTask("Loading " + page.getName() + "...");
            if (!page.isChildrenLoaded()) {
                page.loadChildren();
            }
            IPage[] iPageArray = page.getChildArray();
            int n = iPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPage childPage = iPageArray[n2];
                this.loadNodeRec(childPage, monitor);
                ++n2;
            }
            monitor.subTask("Loading complete");
        }
    }

    private void expandLoadedNodeRec(IPage page) {
        if (page.isChildrenLoaded()) {
            this.m_view.getTreeViewer().setExpandedState((Object)page, true);
            IPage[] iPageArray = page.getChildArray();
            int n = iPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPage ch = iPageArray[n2];
                this.expandLoadedNodeRec(ch);
                ++n2;
            }
        }
    }
}

