/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.form.formdata.ClientBundleUpdateFormDataOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformClientBundleOperation;
import org.eclipse.scout.sdk.ui.action.FormDataUpdateAction;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.InstallClientSessionAction;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.library.LibrariesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientLookupCallTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientSessionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.DesktopExtensionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.DesktopNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.TemplateTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.SearchFormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.AllPagesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class ClientNodePage
extends AbstractPage {
    private ICachedTypeHierarchy m_clientSessionHierarchy;
    private ICachedTypeHierarchy m_desktopHierarchy;
    private ICachedTypeHierarchy m_desktopExtensionHierarchy;
    private final IScoutBundle m_clientProject;
    private IType iClientSession = TypeUtility.getType((String)"org.eclipse.scout.rt.client.IClientSession");
    private IType iDesktop = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.IDesktop");
    private IType iDesktopExtension = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension");

    public ClientNodePage(AbstractPage parent, IScoutBundle clientProject) {
        this.setParent(parent);
        this.m_clientProject = clientProject;
        this.setName(this.getScoutResource().getSimpleName());
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("clientBundle.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ClientNodePage";
    }

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    public void unloadPage() {
        if (this.m_desktopHierarchy != null) {
            this.m_desktopHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_desktopHierarchy = null;
        }
        if (this.m_desktopExtensionHierarchy != null) {
            this.m_desktopExtensionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_desktopExtensionHierarchy = null;
        }
        if (this.m_clientSessionHierarchy != null) {
            this.m_clientSessionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_clientSessionHierarchy = null;
        }
    }

    public IScoutBundle getScoutResource() {
        return this.m_clientProject;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] desktopExtensions;
        IType[] clientSessions;
        if (this.m_clientSessionHierarchy == null) {
            this.m_clientSessionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iClientSession);
            this.m_clientSessionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        if (this.m_desktopHierarchy == null) {
            this.m_desktopHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iDesktop);
            this.m_desktopHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        if (this.m_desktopExtensionHierarchy == null) {
            this.m_desktopExtensionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iDesktopExtension);
            this.m_desktopExtensionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        if ((clientSessions = this.m_clientSessionHierarchy.getAllSubtypes(this.iClientSession, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()))).length > 1) {
            ScoutSdkUi.logWarning("more than one client session found.");
        } else if (clientSessions.length == 0) {
            ScoutSdkUi.logWarning("no client session found.");
        }
        IType[] iTypeArray = clientSessions;
        int n = clientSessions.length;
        int n2 = 0;
        while (n2 < n) {
            IType clientSession = iTypeArray[n2];
            new ClientSessionNodePage(this, clientSession);
            ++n2;
        }
        IType[] desktops = this.m_desktopHierarchy.getAllSubtypes(this.iDesktop, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()));
        if (desktops.length > 1) {
            ScoutSdkUi.logWarning("more than one desktop found.");
        } else if (desktops.length == 0) {
            ScoutSdkUi.logWarning(Texts.get((String)"NoDesktopFound"));
        }
        IType[] iTypeArray2 = desktops;
        int n3 = desktops.length;
        n = 0;
        while (n < n3) {
            IType desktop = iTypeArray2[n];
            new DesktopNodePage(this, desktop);
            ++n;
        }
        IType[] iTypeArray3 = desktopExtensions = this.m_desktopExtensionHierarchy.getAllSubtypes(this.iDesktopExtension, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()));
        int n4 = desktopExtensions.length;
        n3 = 0;
        while (n3 < n4) {
            IType desktopExtension = iTypeArray3[n3];
            new DesktopExtensionNodePage(this, desktopExtension);
            ++n3;
        }
        new FormTablePage(this);
        new SearchFormTablePage(this);
        new WizardTablePage(this);
        try {
            new ClientLookupCallTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("could not load LocalLookupCallTablePage.", e);
        }
        new ClientServiceTablePage(this);
        new OutlineTablePage(this);
        new AllPagesTablePage(this);
        new TemplateTablePage(this);
        try {
            new LibrariesTablePage(this, this.getScoutResource());
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured while loading '" + LibrariesTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{WellformAction.class, FormDataUpdateAction.class, InstallClientSessionAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WellformAction) {
            ((WellformAction)menu).setOperation((IOperation)new WellformClientBundleOperation(this.getScoutResource()));
        } else if (menu instanceof FormDataUpdateAction) {
            ((FormDataUpdateAction)menu).setOperation((IOperation)new ClientBundleUpdateFormDataOperation(this.getScoutResource()));
        } else if (menu instanceof InstallClientSessionAction) {
            ((InstallClientSessionAction)menu).init(this.m_clientSessionHierarchy, this.getScoutResource());
        }
    }
}

