/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.calendar;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.CalendarItemProviderNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.calendar.CalendarItemProviderNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypeOrderChangedPageDirtyListener;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class CalendarItemProviderTablePage
extends AbstractPage {
    final IType iCalendarItemProvider = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider");
    private InnerTypePageDirtyListener m_innerTypeListener;
    private InnerTypeOrderChangedPageDirtyListener m_orderChangedListener;
    private final IType m_calendarType;

    public CalendarItemProviderTablePage(IPage parent, IType calendarType) {
        super.setParent(parent);
        this.m_calendarType = calendarType;
        this.setName(Texts.get((String)"CalendarItemProducerTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("folder_open.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_innerTypeListener != null) {
            TypeCacheAccessor.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(this.getCalendarType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
            this.m_innerTypeListener = null;
        }
        if (this.m_orderChangedListener != null) {
            TypeCacheAccessor.getJavaResourceChangedEmitter().removeJavaResourceChangedListener((IJavaResourceChangedListener)this.m_orderChangedListener);
            this.m_orderChangedListener = null;
        }
        super.unloadPage();
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CalendarItemProviderTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] innerTypes;
        if (this.m_innerTypeListener == null) {
            this.m_innerTypeListener = new InnerTypePageDirtyListener(this, this.iCalendarItemProvider);
            TypeCacheAccessor.getJavaResourceChangedEmitter().addInnerTypeChangedListener(this.getCalendarType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
        }
        if (this.m_orderChangedListener == null) {
            this.m_orderChangedListener = new InnerTypeOrderChangedPageDirtyListener(this, this.iCalendarItemProvider, this.getCalendarType());
            TypeCacheAccessor.getJavaResourceChangedEmitter().addJavaResourceChangedListener((IJavaResourceChangedListener)this.m_orderChangedListener);
        }
        IType[] iTypeArray = innerTypes = ScoutTypeUtility.getCalendarItemProviders((IType)this.getCalendarType());
        int n = innerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType provider = iTypeArray[n2];
            CalendarItemProviderNodePage childPage = new CalendarItemProviderNodePage();
            childPage.setParent(this);
            childPage.setType(provider);
            ++n2;
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{CalendarItemProviderNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        ((CalendarItemProviderNewAction)menu).setType(this.getCalendarType());
    }

    public IType getCalendarType() {
        return this.m_calendarType;
    }
}

