/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.outline;

import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.OutlineServiceNewAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.outline.OutlineServiceNodePage;
import org.eclipse.scout.sdk.ui.type.PackageContentChangedListener;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class OutlineServiceTablePage
extends AbstractPage {
    final IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
    private ICachedTypeHierarchy m_serviceHierarchy;
    private PackageContentChangedListener m_packageContentListener;
    private IPackageFragment m_servicePackage;

    public OutlineServiceTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.m_servicePackage = this.getScoutResource().getPackageFragment(this.getScoutResource().getPackageName(".services.outline"));
        this.m_packageContentListener = new PackageContentChangedListener(this, this.m_servicePackage);
        JavaCore.addElementChangedListener((IElementChangedListener)this.m_packageContentListener);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("services.png"));
        this.setName(Texts.get((String)"OutlineServiceTablePage"));
    }

    @Override
    public void unloadPage() {
        if (this.m_packageContentListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.m_packageContentListener);
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.OutlineServiceTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveAllOutlineServices();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType service = iTypeArray[n2];
            IType serviceInterface = null;
            IType[] interfaces = this.m_serviceHierarchy.getSuperInterfaces(service, TypeFilters.getElementNameFilter((String)("I" + service.getElementName())));
            if (interfaces.length > 0) {
                serviceInterface = interfaces[0];
            }
            new OutlineServiceNodePage(this, service, serviceInterface);
            ++n2;
        }
    }

    protected IType[] resolveAllOutlineServices() {
        if (this.m_serviceHierarchy == null) {
            this.m_serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iService);
        }
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), TypeFilters.getPackageFilter((IPackageFragment)this.m_servicePackage)});
        IType[] services = this.m_serviceHierarchy.getAllSubtypes(this.iService, filter, TypeComparators.getTypeNameComparator());
        return services;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{FormDataSqlBindingValidateAction.class, OutlineServiceNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setTyperesolver(new ITypeResolver(){

                @Override
                public IType[] getTypes() {
                    return OutlineServiceTablePage.this.resolveAllOutlineServices();
                }
            });
        } else if (menu instanceof OutlineServiceNewAction) {
            ((OutlineServiceNewAction)menu).setScoutBundle(this.getScoutResource());
        }
    }
}

