/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import java.util.ArrayList;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.delete.MemberListDeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.PropertyBeansRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.type.IPropertyBean;

public class SharedContextPropertyNodePage
extends AbstractPage {
    private final IPropertyBean m_serverDesc;
    private final IPropertyBean m_clientDesc;

    public SharedContextPropertyNodePage(IPage parent, IPropertyBean clientDesc, IPropertyBean serverDesc) {
        this.setParent(parent);
        this.m_clientDesc = clientDesc;
        this.m_serverDesc = serverDesc;
        IPropertyBean desc = this.getServerDesc();
        if (desc == null) {
            desc = this.getClientDesc();
        }
        this.setName(String.valueOf(NamingUtility.toVariableName((String)desc.getBeanName())) + " (" + Signature.getSignatureSimpleName((String)desc.getBeanSignature()) + ")");
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("variable.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.SharedContextPropertyNodePage";
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{PropertyBeansRenameAction.class, MemberListDeleteAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        super.prepareMenuAction(menu);
        if (menu instanceof MemberListDeleteAction) {
            IMember m;
            int n;
            int n2;
            IMember[] iMemberArray;
            MemberListDeleteAction action = (MemberListDeleteAction)menu;
            if (this.getServerDesc() != null) {
                iMemberArray = this.getServerDesc().getAllMembers();
                n2 = iMemberArray.length;
                n = 0;
                while (n < n2) {
                    m = iMemberArray[n];
                    action.addMemberToDelete(m);
                    ++n;
                }
            }
            if (this.getClientDesc() != null) {
                iMemberArray = this.getClientDesc().getAllMembers();
                n2 = iMemberArray.length;
                n = 0;
                while (n < n2) {
                    m = iMemberArray[n];
                    action.addMemberToDelete(m);
                    ++n;
                }
            }
            action.setImage(ScoutSdkUi.getImageDescriptor("variable_remove.png"));
        } else if (menu instanceof PropertyBeansRenameAction) {
            ArrayList<IPropertyBean> descs = new ArrayList<IPropertyBean>();
            if (this.getClientDesc() != null) {
                descs.add(this.getClientDesc());
            }
            if (this.getServerDesc() != null) {
                descs.add(this.getServerDesc());
            }
            ((PropertyBeansRenameAction)menu).setPropertyBeanDescriptors(descs.toArray(new IPropertyBean[descs.size()]));
        }
    }

    public IPropertyBean getServerDesc() {
        return this.m_serverDesc;
    }

    public IPropertyBean getClientDesc() {
        return this.m_clientDesc;
    }
}

