/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.SearchRangeStyledLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class FormDisplayHintPresenter
extends AbstractProposalPresenter<DisplayHint> {
    public FormDisplayHintPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        SearchRangeStyledLabelProvider labelProvider = new SearchRangeStyledLabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                return ScoutSdkUi.getImage("default.gif");
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])DisplayHint.values(), labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    @Override
    protected DisplayHint parseInput(String input) throws CoreException {
        int parsedInt = PropertyMethodSourceUtility.parseReturnParameterInteger((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        switch (parsedInt) {
            case 0: {
                return DisplayHint.Dialog;
            }
            case 20: {
                return DisplayHint.View;
            }
        }
        return null;
    }

    @Override
    protected synchronized void storeValue(DisplayHint value) {
        if (value == null) {
            this.getProposalField().acceptProposal(this.getDefaultValue());
            value = (DisplayHint)((Object)this.getDefaultValue());
        }
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((DisplayHint)((Object)this.getDefaultValue()), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            StringBuilder source = new StringBuilder("return ");
            switch (value) {
                case Dialog: {
                    source.append("DISPLAY_HINT_DIALOG");
                    break;
                }
                case View: {
                    source.append("DISPLAY_HINT_VIEW");
                }
            }
            source.append(";");
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), source.toString(), true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }

    protected static enum DisplayHint {
        Dialog,
        View;

    }
}

