/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class LabelHorizontalAlignmentPresenter
extends AbstractProposalPresenter<HorizontalAlignment> {
    public LabelHorizontalAlignmentPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                HorizontalAlignment value = (HorizontalAlignment)((Object)element);
                switch (value) {
                    case Left: {
                        return ScoutSdkUi.getImage("horizontal_left.gif");
                    }
                    case Center: {
                        return ScoutSdkUi.getImage("horizontal_center.gif");
                    }
                    case Right: {
                        return ScoutSdkUi.getImage("horizontal_right.gif");
                    }
                }
                return ScoutSdkUi.getImage("default.gif");
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])HorizontalAlignment.values(), (ILabelProvider)labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    @Override
    protected HorizontalAlignment parseInput(String input) throws CoreException {
        int parsedInt = PropertyMethodSourceUtility.parseReturnParameterInteger((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        switch (parsedInt) {
            case -1: {
                return HorizontalAlignment.Left;
            }
            case 0: {
                return HorizontalAlignment.Center;
            }
            case 1: {
                return HorizontalAlignment.Right;
            }
        }
        return HorizontalAlignment.Default;
    }

    @Override
    protected void storeValue(HorizontalAlignment value) {
        if (value == null) {
            this.getProposalField().acceptProposal(this.getDefaultValue());
            value = (HorizontalAlignment)((Object)this.getDefaultValue());
        }
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((HorizontalAlignment)((Object)this.getDefaultValue()), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            String sourceValue;
            switch (value) {
                case Left: {
                    sourceValue = "-1";
                    break;
                }
                case Center: {
                    sourceValue = "0";
                    break;
                }
                case Right: {
                    sourceValue = "1";
                    break;
                }
                default: {
                    sourceValue = "1000";
                }
            }
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + sourceValue + ";", true);
        }
        if (op != null) {
            OperationJob job = new OperationJob(new IOperation[]{op});
            job.schedule();
        }
    }

    protected static enum HorizontalAlignment {
        Left,
        Center,
        Right,
        Default;

    }
}

