/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.wizard.export.AbstractExportProductWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.widgets.Composite;

public class ExportServerWizardPage
extends AbstractExportProductWizardPage {
    private static final String SETTINGS_PRODUCT_FILE = "productFileSetting";
    private static final String SETTINGS_WAR_FILE_NAME = "warFileNameSetting";

    public ExportServerWizardPage(IScoutProject scoutProject) {
        super(scoutProject, ExportServerWizardPage.class.getName(), Texts.get((String)"ExportWebArchive"), 5, SETTINGS_PRODUCT_FILE, SETTINGS_WAR_FILE_NAME);
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        if (!StringUtility.hasText((String)this.m_warFileName.getModifiableText())) {
            String warName = this.findServerWarName();
            if (warName == null) {
                warName = this.getWizard().getProjectAlias();
            }
            this.m_warFileName.setText(warName);
        }
    }

    private String findServerWarName() {
        String warName = null;
        if (this.getScoutProject().getUiSwingBundle() != null) {
            warName = this.findServerNameInClientBundle(this.getScoutProject().getUiSwingBundle());
        }
        if (warName == null && this.getScoutProject().getUiSwtBundle() != null) {
            warName = this.findServerNameInClientBundle(this.getScoutProject().getUiSwtBundle());
        }
        return warName;
    }

    private String findServerNameInClientBundle(IScoutBundle bundle) {
        block2: {
            P_ConfigIniVisitor visitor = new P_ConfigIniVisitor();
            try {
                bundle.getProject().accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                if (!e.getStatus().isOK()) break block2;
                return visitor.getName();
            }
        }
        return null;
    }

    private static class P_ConfigIniVisitor
    implements IResourceVisitor {
        private static final Pattern SERVER_URL_PATTERN = Pattern.compile("\\/([^\\/]*)\\/process");
        private String m_name;

        private P_ConfigIniVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && CompareUtility.equals((Object)"config.ini", (Object)resource.getName()) && resource.exists()) {
                this.parseConfigIniFile((IFile)resource);
            }
            return true;
        }

        private void parseConfigIniFile(IFile configIniFile) throws CoreException {
            block16: {
                Properties props = new Properties();
                InputStream is = null;
                try {
                    try {
                        is = configIniFile.getContents();
                        props.load(is);
                        String serverUrl = props.getProperty("server.url");
                        if (StringUtility.hasText((String)serverUrl)) {
                            Matcher m = SERVER_URL_PATTERN.matcher(serverUrl);
                            if (m.find()) {
                                this.m_name = m.group(1);
                            }
                            throw new CoreException(Status.OK_STATUS);
                        }
                    }
                    catch (IOException e) {
                        ScoutSdkUi.logError("could not parse file '" + configIniFile.getFullPath() + "'.", e);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public String getName() {
            return this.m_name;
        }
    }
}

