/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.FormStackNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.SearchFormNewWizard;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SearchFormNewWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_NLS_NAME = "nlsName";
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_TABLE_PAGE = "tablePage";
    final IType iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
    final IType iSearchForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
    final IType abstractSearchForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractSearchForm");
    final IType iPage = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage");
    final IType iPageWithTable = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_tablePageField;
    private final IScoutBundle m_clientBundle;

    public SearchFormNewWizardPage(IScoutBundle clientBundle) {
        super(SearchFormNewWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle(Texts.get((String)"SearchForm2"));
        this.setDescription(Texts.get((String)"CreateANewSearchForm"));
        this.setSuperTypeInternal(this.abstractSearchForm);
    }

    @Override
    protected void createContent(Composite parent) {
        Control tablePageGroup = this.createTablePageGroup(parent);
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, this.getClientBundle().findBestMatchNlsProject(), Texts.get((String)"Name"));
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SearchFormNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = SearchFormNewWizardPage.this.getNlsName();
                    INlsEntry newName = (INlsEntry)event.proposal;
                    SearchFormNewWizardPage.this.setNlsNameInternal(newName);
                    if (newName != null && (oldEntry == null || StringUtility.isNullOrEmpty((String)SearchFormNewWizardPage.this.m_typeNameField.getModifiableText()) || oldEntry.getKey().equals(SearchFormNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        SearchFormNewWizardPage.this.m_typeNameField.setText(newName.getKey());
                    }
                }
                finally {
                    SearchFormNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("SearchForm");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchFormNewWizardPage.this.setTypeNameInternal(SearchFormNewWizardPage.this.m_typeNameField.getText());
                SearchFormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iSearchForm, this.getClientBundle().getJavaProject(), this.abstractSearchForm));
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SearchFormNewWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                SearchFormNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        tablePageGroup.setLayoutData((Object)new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
    }

    private Control createTablePageGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Texts.get((String)"AutoCreate"));
        Label label = new Label((Composite)group, 0);
        label.setText(Texts.get((String)"SelectTablePageForSearchForm"));
        this.m_tablePageField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"TablePage"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                IType[] list = TypeUtility.getPrimaryTypeHierarchy((IType)SearchFormNewWizardPage.this.iPage).getAllSubtypes(SearchFormNewWizardPage.this.iPageWithTable, TypeFilters.getTypesOnClasspath((IJavaProject)SearchFormNewWizardPage.this.getClientBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
                return new Object[][]{list};
            }
        });
        this.m_tablePageField.acceptProposal(this.getTablePageType());
        this.m_tablePageField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SearchFormNewWizardPage.this.setTablePageTypeInternal((IType)event.proposal);
                SearchFormNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        label.setLayoutData((Object)new GridData(768));
        this.m_tablePageField.setLayoutData(new GridData(768));
        return group;
    }

    @Override
    public void setFocus() {
        if (this.m_tablePageField.getSelectedProposal() == null) {
            this.m_tablePageField.setFocus();
        } else {
            this.m_nlsNameField.setFocus();
        }
    }

    void fillOperation(FormStackNewOperation operation) {
        IType superTypeProp;
        operation.setFormName(this.getTypeName());
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName());
        }
        if ((superTypeProp = this.getSuperType()) != null) {
            operation.setFormSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getFullyQualifiedName(), (boolean)true));
        }
    }

    public SearchFormNewWizard getWizard() {
        return (SearchFormNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("SearchForm")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(".ui.searchforms")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public INlsEntry getNlsName() {
        return (INlsEntry)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(INlsEntry proposal) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(proposal);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(proposal);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(INlsEntry proposal) {
        this.setProperty(PROP_NLS_NAME, proposal);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public IType getTablePageType() {
        return (IType)this.getProperty(PROP_TABLE_PAGE);
    }

    public void setTablePageType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setTablePageTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_tablePageField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTablePageTypeInternal(IType superType) {
        this.setProperty(PROP_TABLE_PAGE, superType);
    }
}

