/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.menu;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.MenuNewOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.menu.MenuNewWizardPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class DesktopMenuNewWizard
extends AbstractWorkspaceWizard {
    private MenuNewWizardPage m_page1;
    private IType m_declaringType;
    private MenuNewOperation m_operation;

    public DesktopMenuNewWizard() {
        this.setWindowTitle(Texts.get((String)"NewDesktopMenu"));
    }

    public void initWizard(IType declaringType) {
        this.m_declaringType = declaringType;
        this.m_page1 = new MenuNewWizardPage(this.getDeclaringType());
        this.addPage((IWizardPage)this.m_page1);
    }

    public void setSuperType(IType superType) {
        this.m_page1.setSuperType(superType);
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        this.m_operation = new MenuNewOperation(this.getDeclaringType(), true);
        this.m_operation.setNlsEntry(this.m_page1.getNlsName());
        this.m_operation.setTypeName(this.m_page1.getTypeName());
        IType superTypeProp = this.m_page1.getSuperType();
        if (superTypeProp != null) {
            String signature = Signature.createTypeSignature((String)superTypeProp.getFullyQualifiedName(), (boolean)true);
            this.m_operation.setSuperTypeSignature(signature);
        }
        if (this.m_page1.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredDesktop((IType)this.m_declaringType);
            this.m_operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_MENU));
        } else {
            this.m_operation.setSibling(this.m_page1.getSibling().getElement());
        }
        this.m_operation.setFormToOpen(this.m_page1.getFormToOpen());
        this.m_operation.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void postFinishDisplayThread() {
        IType createdField = this.m_operation.getCreatedMenu();
        if (TypeUtility.exists((IJavaElement)createdField)) {
            ScoutSdkUi.showJavaElementInEditor((IJavaElement)createdField, false);
        }
    }
}

