/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.WizardNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WizardNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iWizard = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizard");
    final IType abstractWizard = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.wizard.AbstractWizard");
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private final IScoutBundle m_clientBundle;

    public WizardNewWizardPage(IScoutBundle clientBundle) {
        super(WizardNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewWizard"));
        this.setDescription(Texts.get((String)"CreateANewWizard"));
        this.m_clientBundle = clientBundle;
        this.m_superType = this.abstractWizard;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, this.getClientBundle().findBestMatchNlsProject(), Texts.get((String)"Name"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    WizardNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = WizardNewWizardPage.this.getNlsName();
                    WizardNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (WizardNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(WizardNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)WizardNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        WizardNewWizardPage.this.m_typeNameField.setText(WizardNewWizardPage.this.m_nlsName.getKey());
                    }
                }
                finally {
                    WizardNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Wizard");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardNewWizardPage.this.m_typeName = WizardNewWizardPage.this.m_typeNameField.getText();
                WizardNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iWizard, this.getClientBundle().getJavaProject(), this.abstractWizard));
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                WizardNewWizardPage.this.m_superType = (IType)event.proposal;
                WizardNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        GridData tablePageData = new GridData(768);
        this.m_nlsNameField.setLayoutData(tablePageData);
        this.m_typeNameField.setLayoutData(tablePageData);
        this.m_superTypeField.setLayoutData(tablePageData);
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        WizardNewOperation m_operation = new WizardNewOperation();
        m_operation.setClientBundle(this.getClientBundle());
        if (this.getNlsName() != null) {
            m_operation.setNlsEntry(this.getNlsName());
        }
        m_operation.setTypeName(this.getTypeName());
        IType superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            m_operation.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getFullyQualifiedName(), (boolean)true));
        }
        m_operation.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Wizard")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(".ui.wizards")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

