/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProductSelectionDialog
extends TitleAreaDialog {
    private IScoutProject m_project;
    private ITreeNode m_rootNode;
    private CheckableTree m_tree;
    private IFile[] m_checkedFiles;
    private boolean m_multiSelectionMode = true;
    private boolean m_productSelectionRequired;
    private IFile m_selectedProductFile;
    private ITreeNodeFilter m_visibleNodeFilter;

    public ProductSelectionDialog(Shell parentShell, IScoutProject project) {
        this(parentShell, project, NodeFilters.getAcceptAll());
    }

    public ProductSelectionDialog(Shell parentShell, IScoutProject project, ITreeNodeFilter visibleFilter) {
        super(parentShell);
        this.m_project = project;
        this.m_visibleNodeFilter = visibleFilter;
        this.setTitle(Texts.get((String)"ProductSelectionDialogTitle"));
        this.m_checkedFiles = new IFile[0];
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public ProductSelectionDialog(Shell parentShell, ITreeNode rootNode) {
        super(parentShell);
        this.m_rootNode = rootNode;
        this.setTitle(Texts.get((String)"ProductSelectionDialogTitle"));
        this.m_checkedFiles = new IFile[0];
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootPane = new Composite(parent, 0);
        this.m_tree = new CheckableTree(rootPane, this.getRootNode());
        this.m_tree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                ArrayList<IFile> checkedFiles = new ArrayList<IFile>();
                ITreeNode[] iTreeNodeArray = ProductSelectionDialog.this.m_tree.getCheckedNodes();
                int n = iTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNode n3 = iTreeNodeArray[n2];
                    if (n3.getType() == 2999) {
                        checkedFiles.add((IFile)n3.getData());
                    }
                    ++n2;
                }
                ProductSelectionDialog.this.m_checkedFiles = checkedFiles.toArray(new IFile[checkedFiles.size()]);
            }
        });
        this.m_tree.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new P_TreeSelectionListener());
        this.m_tree.setChecked(TreeUtility.findNodes(this.m_rootNode, NodeFilters.getByData(this.m_checkedFiles)));
        if (parent.getLayout() instanceof GridLayout) {
            rootPane.setLayoutData((Object)new GridData(1808));
        }
        rootPane.setLayout((Layout)new GridLayout(1, true));
        this.m_tree.setLayoutData(new GridData(1808));
        return rootPane;
    }

    public ITreeNode getRootNode() {
        if (this.m_rootNode == null) {
            this.m_rootNode = TreeUtility.createProductTree(this.m_project, this.getVisibleNodeFilter(), this.isMultiSelectionMode());
        }
        return this.m_rootNode;
    }

    public IFile[] getCheckedProductFiles() {
        if (this.isMultiSelectionMode()) {
            return this.m_checkedFiles;
        }
        return new IFile[]{this.m_selectedProductFile};
    }

    public IFile getSelectedProductFile() {
        return this.m_selectedProductFile;
    }

    public void setCheckedProductFiles(IFile[] array) {
        this.m_checkedFiles = array;
        if (this.m_tree != null && !this.m_tree.isDisposed()) {
            ITreeNode[] treeNodes = TreeUtility.findNodes(this.m_rootNode, NodeFilters.getByData(array));
            if (this.isMultiSelectionMode()) {
                this.m_tree.setChecked(treeNodes);
            } else if (treeNodes.length > 0) {
                ArrayList<ITreeNode> pathElements = new ArrayList<ITreeNode>();
                ITreeNode n = treeNodes[0];
                while (n != null) {
                    pathElements.add(pathElements.size(), n);
                    n = n.getParent();
                }
                this.m_tree.getTreeViewer().setSelection((ISelection)new TreeSelection(new TreePath(pathElements.toArray())));
            }
        }
    }

    public boolean isMultiSelectionMode() {
        return this.m_multiSelectionMode;
    }

    public void setMultiSelectionMode(boolean multiSelectionMode) {
        this.m_multiSelectionMode = multiSelectionMode;
    }

    public boolean isProductSelectionRequired() {
        return this.m_productSelectionRequired;
    }

    public void setProductSelectionRequired(boolean productSelectionRequired) {
        this.m_productSelectionRequired = productSelectionRequired;
    }

    public ITreeNodeFilter getVisibleNodeFilter() {
        return this.m_visibleNodeFilter;
    }

    private class P_TreeSelectionListener
    implements ISelectionChangedListener {
        private P_TreeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ITreeNode treeNode;
            Object selectedElement;
            IStructuredSelection selection;
            boolean pageComplete;
            ProductSelectionDialog.this.m_selectedProductFile = null;
            boolean bl = pageComplete = !ProductSelectionDialog.this.isProductSelectionRequired();
            if (!pageComplete && !(selection = (IStructuredSelection)event.getSelection()).isEmpty() && (selectedElement = selection.getFirstElement()) instanceof TreeNode && (treeNode = (ITreeNode)selectedElement).getType() == 2999) {
                ProductSelectionDialog.this.m_selectedProductFile = (IFile)treeNode.getData();
                pageComplete = true;
            }
            ProductSelectionDialog.this.getButton(0).setEnabled(pageComplete);
        }
    }
}

