/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.nls;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.action.NlsEntryNewAction;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalSelectionHandler;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;

public class NlsTextSelectionHandler
implements IProposalSelectionHandler {
    private final INlsProject m_nlsProject;

    public NlsTextSelectionHandler(INlsProject nlsProject) {
        if (nlsProject == null) {
            throw new IllegalArgumentException("nls project must not be null!");
        }
        this.m_nlsProject = nlsProject;
    }

    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }

    @Override
    public void handleProposalAccepted(Object proposal, String searchText, ProposalTextField proposalTextField) {
        if (NlsTextContentProvider.NLS_NEW_PROPOSAL == proposal) {
            String proposalFieldText = "";
            if (!StringUtility.isNullOrEmpty((String)searchText)) {
                proposalFieldText = searchText;
            }
            String key = this.getNewKey(proposalFieldText);
            NlsEntry entry = new NlsEntry(key, this.getNlsProject());
            Language devLang = this.getNlsProject().getDevelopmentLanguage();
            entry.addTranslation(devLang, proposalFieldText);
            if (!Language.LANGUAGE_DEFAULT.equals((Object)devLang)) {
                entry.addTranslation(Language.LANGUAGE_DEFAULT, proposalFieldText);
            }
            NlsEntryNewAction action = new NlsEntryNewAction(proposalTextField.getShell(), this.getNlsProject(), entry, true);
            action.run();
            try {
                action.join();
            }
            catch (InterruptedException e) {
                ScoutSdkUi.logWarning(e);
            }
            entry = action.getEntry();
            if (entry != null) {
                proposalTextField.acceptProposal(entry);
                return;
            }
            proposalTextField.acceptProposal(null);
        } else {
            proposalTextField.acceptProposal(proposal);
        }
    }

    protected String getNewKey(String value) {
        return this.getNlsProject().generateNewKey(value);
    }
}

