/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.technology.laf;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.sdk.ui.extensions.technology.AbstractScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.technology.IMarketplaceConstants;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutProject;

public class RayoUiSwingProdTechnologyHandler
extends AbstractScoutTechnologyHandler
implements IMarketplaceConstants {
    private static final String SCOUT_LAF_KEY = "scout.laf";
    private static final String RAYO_LAF_NAME = "com.bsiag.scout.rt.ui.swing.laf.rayo.Rayo";

    @Override
    public void selectionChanged(IScoutTechnologyResource[] resources, boolean selected, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        this.selectionChangedProductFiles(resources, selected, (String[][])new String[][]{{"com.bsiag.scout.rt.ui.swing.rayo", "com.bsiag.scout.rt.ui.swing.laf.rayo.fragment"}});
        IScoutTechnologyResource[] iScoutTechnologyResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutTechnologyResource res = iScoutTechnologyResourceArray[n2];
            ProductFileModelHelper pfmh = new ProductFileModelHelper(res.getResource());
            if (selected) {
                pfmh.ConfigurationFile.setEntry(SCOUT_LAF_KEY, RAYO_LAF_NAME);
            } else {
                pfmh.ConfigurationFile.removeEntry(SCOUT_LAF_KEY);
            }
            pfmh.save();
            ++n2;
        }
    }

    @Override
    public TriState getSelection(IScoutProject project) {
        TriState ret = this.getSelectionProductFiles(project, new String[]{"org.eclipse.scout.rt.client", "org.eclipse.scout.rt.ui.swing"}, new String[][]{{"com.bsiag.scout.rt.ui.swing.rayo", "com.bsiag.scout.rt.ui.swing.laf.rayo.fragment"}});
        AbstractScoutTechnologyHandler.P_TechProductFile[] productFiles = this.getFilteredProductFiles(project, "org.eclipse.scout.rt.client", "org.eclipse.scout.rt.ui.swing");
        if (productFiles == null || productFiles.length == 0) {
            return ret;
        }
        int i = 0;
        while (i < productFiles.length) {
            TriState tmp = TriState.parseTriState((Object)this.isRayoLafEnabledInConfigIni(productFiles[i].productFile));
            if (ret != tmp) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean isActive(IScoutProject project) {
        return project.getClientBundle() != null && project.getClientBundle().getProject().exists() && project.getUiSwingBundle() != null && project.getUiSwingBundle().getProject().exists();
    }

    @Override
    protected void contributeResources(IScoutProject project, List<IScoutTechnologyResource> list) {
        this.contributeProductFiles(project, list, "org.eclipse.scout.rt.client", "org.eclipse.scout.rt.ui.swing");
    }

    private boolean isRayoLafEnabledInConfigIni(IFile productFile) {
        try {
            ProductFileModelHelper pfmh = new ProductFileModelHelper(productFile);
            String scoutLaf = pfmh.ConfigurationFile.getEntry(SCOUT_LAF_KEY);
            return RAYO_LAF_NAME.equals(scoutLaf);
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("cannot parse product file: " + productFile, e);
            return false;
        }
    }
}

