/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.icons;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.icon.IIconProvider;
import org.eclipse.scout.sdk.icon.ScoutIconDesc;
import org.eclipse.scout.sdk.ui.fields.proposal.icon.IconContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.icon.IconLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.icons.IconRowFilter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class IconsEditor
extends EditorPart {
    public static final String ID = IconsEditor.class.getName();
    private FormToolkit m_toolkit;
    private Form m_form;
    private Table m_table;
    private TableViewer m_viewer;
    private IconRowFilter m_inheritedFilter = new IconRowFilter();
    private IIconProvider m_iconProvider;

    public void createPartControl(Composite parent) {
        this.m_toolkit = new FormToolkit(parent.getDisplay());
        this.m_form = this.m_toolkit.createForm(parent);
        this.m_form.setText(Texts.get((String)"Icons"));
        Composite body = this.m_form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.createFormBody(body);
    }

    private void createFormBody(Composite parent) {
        this.m_table = this.m_toolkit.createTable(parent, 65536);
        this.m_table.setLinesVisible(true);
        this.m_table.setHeaderVisible(true);
        TableColumn[] columns = new TableColumn[3];
        columns[0] = new TableColumn(this.m_table, 16384);
        columns[0].setWidth(20);
        columns[1] = new TableColumn(this.m_table, 16384);
        columns[1].setText(Texts.get((String)"KEY"));
        columns[1].setWidth(300);
        columns[2] = new TableColumn(this.m_table, 16384);
        columns[2].setText(Texts.get((String)"Name"));
        columns[2].setWidth(300);
        P_SortSelectionAdapter sortListener = new P_SortSelectionAdapter();
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            c.addSelectionListener((SelectionListener)sortListener);
            ++n2;
        }
        this.m_viewer = new TableViewer(this.m_table);
        P_IconLabelProvider labelProvider = new P_IconLabelProvider(this.m_table.getDisplay());
        IconContentProvider contentProvider = new IconContentProvider(this.m_iconProvider, (ILabelProvider)labelProvider);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.m_viewer.setContentProvider((IContentProvider)contentProvider);
        this.m_viewer.setSorter((ViewerSorter)new P_Sorter());
        this.m_viewer.setInput((Object)contentProvider.getProposals(null, null));
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_table.setLayoutData((Object)new GridData(1808));
    }

    public void setScoutSharedBundle(IScoutBundle sharedBundle) {
        if (sharedBundle != null) {
            this.m_iconProvider = sharedBundle.findBestMatchIconProvider();
            if (this.m_viewer != null && !this.m_viewer.getControl().isDisposed()) {
                this.m_viewer.setContentProvider((IContentProvider)new IconContentProvider(this.m_iconProvider, (ILabelProvider)this.m_viewer.getLabelProvider()));
                this.m_viewer.refresh();
            }
        }
    }

    public void setHideInherited(boolean hideInherited) {
        this.m_table.setRedraw(false);
        try {
            if (hideInherited) {
                this.m_viewer.addFilter((ViewerFilter)this.m_inheritedFilter);
            } else {
                this.m_viewer.removeFilter((ViewerFilter)this.m_inheritedFilter);
            }
        }
        finally {
            this.m_table.setRedraw(true);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            IScoutBundle scoutProject = ScoutSdkCore.getScoutWorkspace().getScoutBundle(file.getProject());
            if (scoutProject.getType() == 4) {
                this.setScoutSharedBundle(scoutProject);
            }
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void setFocus() {
        this.m_form.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private class P_IconLabelProvider
    extends IconLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        public P_IconLabelProvider(Display display) {
            super(display);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image img = null;
            if (columnIndex == 0) {
                img = super.getImage(element);
            }
            return img;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return ((ScoutIconDesc)element).getId();
                }
                case 2: {
                    return ((ScoutIconDesc)element).getIconName();
                }
            }
            return "";
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            Color c = null;
            if (element instanceof ScoutIconDesc && ((ScoutIconDesc)element).isInherited()) {
                c = ScoutSdkUi.getColor("inactiveForeground");
            }
            return c;
        }
    }

    private class P_SortSelectionAdapter
    extends SelectionAdapter {
        private P_SortSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            if (IconsEditor.this.m_table.getSortColumn() == col) {
                if (IconsEditor.this.m_table.getSortDirection() == 128) {
                    IconsEditor.this.m_table.setSortDirection(1024);
                } else {
                    IconsEditor.this.m_table.setSortDirection(128);
                }
            } else {
                IconsEditor.this.m_table.setSortColumn(col);
                IconsEditor.this.m_table.setSortDirection(128);
            }
            IconsEditor.this.m_viewer.refresh();
        }
    }

    private class P_Sorter
    extends ViewerSorter {
        private P_Sorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Table table = (Table)viewer.getControl();
            boolean sortAsc = table.getSortDirection() == 128;
            int c = super.compare(viewer, e1, e2);
            if (!sortAsc) {
                c = -c;
            }
            return c;
        }
    }
}

