/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form;

import java.util.HashSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformFormsOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.MultipleUpdateFormDataAction;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.FormNewAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class FormTablePage
extends AbstractPage {
    final IType iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
    final IType iSearchForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
    private ICachedTypeHierarchy m_formHierarchy;

    public FormTablePage(AbstractPage parent) {
        this.setName(Texts.get((String)"FormTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("forms.png"));
        this.setParent(parent);
    }

    @Override
    public void unloadPage() {
        if (this.m_formHierarchy != null) {
            this.m_formHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_formHierarchy != null) {
            this.m_formHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.FormTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveForms();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            new FormNodePage(this, t);
            ++n2;
        }
    }

    protected IType[] resolveForms() {
        if (this.m_formHierarchy == null) {
            this.m_formHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iForm);
            this.m_formHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] searchForms = this.m_formHierarchy.getAllSubtypes(this.iSearchForm, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()));
        IType[] allSubtypes = this.m_formHierarchy.getAllSubtypes(this.iForm, (ITypeFilter)new P_FormFilter(searchForms, this.getScoutResource().getJavaProject()), TypeComparators.getTypeNameComparator());
        return allSubtypes;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{WellformAction.class, FormNewAction.class, MultipleUpdateFormDataAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WellformAction) {
            WellformAction action = (WellformAction)menu;
            action.setOperation((IOperation)new WellformFormsOperation(this.getScoutResource()));
            action.setLabel(Texts.get((String)"WellformAllForms"));
        } else if (menu instanceof FormNewAction) {
            ((FormNewAction)menu).setScoutBundle(this.getScoutResource());
        } else if (menu instanceof MultipleUpdateFormDataAction) {
            ((MultipleUpdateFormDataAction)menu).setTypeResolver(new ITypeResolver(){

                @Override
                public IType[] getTypes() {
                    return FormTablePage.this.resolveForms();
                }
            });
        }
    }

    private class P_FormFilter
    implements ITypeFilter {
        private HashSet<String> m_searchForms = new HashSet();
        private ITypeFilter m_classesInProjectFilter;

        public P_FormFilter(IType[] searchForms, IJavaProject javaProject) {
            this.m_classesInProjectFilter = TypeFilters.getClassesInProject((IJavaProject)javaProject);
            IType[] iTypeArray = searchForms;
            int n = searchForms.length;
            int n2 = 0;
            while (n2 < n) {
                IType t = iTypeArray[n2];
                this.m_searchForms.add(t.getHandleIdentifier());
                ++n2;
            }
        }

        public boolean accept(IType type) {
            if (!this.m_searchForms.contains(type.getHandleIdentifier())) {
                return this.m_classesInProjectFilter.accept(type);
            }
            return false;
        }
    }
}

