/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.delete.MemberListDeleteAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ServiceOperationNodePage
extends AbstractPage {
    private final IMethod m_interfaceOpMethod;
    private final IMethod m_implementationOpMethod;

    public ServiceOperationNodePage(AbstractPage parent, IMethod method, IMethod implementationMethod) {
        this.setParent(parent);
        this.m_interfaceOpMethod = method;
        this.m_implementationOpMethod = implementationMethod;
        this.setName(ServiceOperationNodePage.getMethodDisplayName(this.m_implementationOpMethod));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("serviceOperation.png"));
    }

    private static String getMethodDisplayName(IMethod m) {
        StringBuilder displayName = new StringBuilder(m.getElementName());
        displayName.append("(");
        String[] paramTypes = m.getParameterTypes();
        int i = 0;
        while (i < paramTypes.length) {
            displayName.append(Signature.getSignatureSimpleName((String)paramTypes[i]));
            if (i < paramTypes.length - 1) {
                displayName.append(", ");
            }
            ++i;
        }
        displayName.append(")");
        return displayName.toString();
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ServiceOperationNodePage";
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{MemberListDeleteAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        super.prepareMenuAction(menu);
        if (menu instanceof MemberListDeleteAction) {
            MemberListDeleteAction action = (MemberListDeleteAction)menu;
            if (TypeUtility.exists((IJavaElement)this.getInterfaceOpMethod())) {
                action.addMemberToDelete((IMember)this.getInterfaceOpMethod());
            }
            action.addMemberToDelete((IMember)this.getImplementationOpMethod());
            action.setImage(ScoutSdkUi.getImageDescriptor("serviceOperation_remove.png"));
        }
    }

    @Override
    public boolean handleDoubleClickedDelegate() {
        try {
            ITextEditor textEditor;
            IRegion reg;
            IMethod jdtMember = this.getImplementationOpMethod();
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)jdtMember);
            JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)jdtMember);
            if (editor instanceof ITextEditor && (reg = (textEditor = (ITextEditor)editor).getHighlightRange()) != null) {
                textEditor.setHighlightRange(reg.getOffset(), reg.getLength(), true);
            }
            return true;
        }
        catch (Exception ex) {
            ScoutSdkUi.logWarning(ex);
            return false;
        }
    }

    public IMethod getInterfaceOpMethod() {
        return this.m_interfaceOpMethod;
    }

    public IMethod getImplementationOpMethod() {
        return this.m_implementationOpMethod;
    }
}

