/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformCodeTypesOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.CodeTypeNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeTypeNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class CodeTypeTablePage
extends AbstractPage {
    final IType iCodeType = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType");
    private ICachedTypeHierarchy m_codeTypeHierarchy;

    public CodeTypeTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"EnumerationTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("codeTypes.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_codeTypeHierarchy != null) {
            this.m_codeTypeHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CodeTypeTablePage";
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_codeTypeHierarchy != null) {
            this.m_codeTypeHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] codeTypes;
        if (this.m_codeTypeHierarchy == null) {
            this.m_codeTypeHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iCodeType);
            this.m_codeTypeHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        ITypeFilter filter = TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject());
        IType[] iTypeArray = codeTypes = this.m_codeTypeHierarchy.getAllSubtypes(this.iCodeType, filter, TypeComparators.getTypeNameComparator());
        int n = codeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType codeType = iTypeArray[n2];
            new CodeTypeNodePage(this, codeType);
            ++n2;
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{WellformAction.class, CodeTypeNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WellformAction) {
            WellformAction action = (WellformAction)menu;
            action.setOperation((IOperation)new WellformCodeTypesOperation(this.getScoutResource()));
            action.setLabel(Texts.get((String)"WellformAllCodeTypes"));
        } else if (menu instanceof CodeTypeNewAction) {
            ((CodeTypeNewAction)menu).setScoutBundle(this.getScoutResource());
        }
    }
}

